/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.provider;

import javax.persistence.EntityManager;

import org.faktorips.runtime.internal.toc.AbstractReadonlyTableOfContents;
import org.faktorips.runtime.productdata.jpa.toc.DbTableOfContents;
import org.faktorips.runtime.productdataprovider.IProductDataProviderFactory;

/**
 * Creates {@link DbProductDataProvider JpaProductDataProviders} for tables of content identified by
 * {@code name} and {@code version}, reading the {@link DbTableOfContents} from a
 * {@link ProductDatabaseBean}.
 */
public class DbProductDataProviderFactory implements IProductDataProviderFactory {

    private String name;
    private String modelVersion;
    private ProductDatabase productDatabase;

    /**
     * Creates {@link DbProductDataProvider JpaProductDataProviders} for tables of content
     * identified by {@code name} and {@code version} using the {@link EntityManager} to read the
     * {@link DbTableOfContents} from the database.
     * 
     * @param name the name identifying a table of contents
     * @param modelVersion the version of the model matching the product data contained in the table
     *            of contents
     * @param productDatabase the {@link ProductDatabaseBean} used for up-to-date checks
     */
    public DbProductDataProviderFactory(String name, String modelVersion, ProductDatabase productDatabase) {
        this.name = name;
        this.modelVersion = modelVersion;
        this.productDatabase = productDatabase;
    }

    public DbProductDataProviderFactory(String name, AbstractReadonlyTableOfContents modelTableOfContents,
            ProductDatabase productDatabase) {
        this.name = name;
        modelVersion = modelTableOfContents.getProductDataVersion();
        this.productDatabase = productDatabase;
    }

    @Override
    public DbProductDataProvider newInstance() {
        return new DbProductDataProvider(name, modelVersion, productDatabase);
    }

}
