/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.provider;

import javax.ejb.Local;
import javax.persistence.EntityManager;

import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity.Status;

@Local
public interface ProductDatabase {

    /**
     * Gets the {@link TocVersionEntity} marked as {@link Status#ACTIVE} for the given {@code name}
     * and {@code modelVersion} from the {@link EntityManager}.
     * 
     * @param name the name identifying a table of contents
     * @param modelVersion the version of the model matching the product data contained in the table
     *            of contents
     * @return the {@link Status#ACTIVE active} {@link TocVersionEntity}
     * 
     * @throws IllegalStateException if more than one version for the given {@code name} and
     *             {@code modelVersion} is marked as {@link Status#ACTIVE}
     */
    TocVersionEntity getActiveTocVersion(String name, String modelVersion);

    /**
     * Gets the {@link TocVersionEntity#getVersion() version of the TocVersion} marked as
     * {@link Status#ACTIVE} for the given {@code name} and {@code modelVersion} from the
     * {@link EntityManager}.
     * 
     * @param name the name identifying a table of contents
     * @param modelVersion the version of the model matching the product data contained in the table
     *            of contents
     * @return the {@link Status#ACTIVE active} {@link TocVersionEntity}
     * 
     * @throws IllegalStateException if more than one version for the given {@code name} and
     *             {@code modelVersion} is marked as {@link Status#ACTIVE}
     */
    String getActiveVersionNumber(String name, String modelVersion);

}