/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.provider;

import java.text.MessageFormat;

import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;

import org.faktorips.runtime.productdata.jpa.commons.AbstractProductDatabase;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity.Status;

@Stateless
@Local(ProductDatabase.class)
@TransactionAttribute(TransactionAttributeType.REQUIRES_NEW)
public class ProductDatabaseBean extends AbstractProductDatabase implements ProductDatabase {

    public ProductDatabaseBean() {
        // enables injection
    }

    public ProductDatabaseBean(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public TocVersionEntity getActiveTocVersion(String name, String modelVersion) {
        try {
            return (TocVersionEntity)getActiveTocVersionQuery(name, modelVersion).getSingleResult();
        } catch (NonUniqueResultException e) {
            throw new IllegalStateException(
                    MessageFormat.format("There is more than one version marked as {0} for toc {1}, model version {2}",
                            Status.ACTIVE, name, modelVersion),
                    e);
        } catch (NoResultException e) {
            throw new IllegalArgumentException(
                    MessageFormat.format("There is no version marked as {0} for toc {1}, model version {2}",
                            Status.ACTIVE, name, modelVersion),
                    e);
        }
    }

    @Override
    public String getActiveVersionNumber(String name, String modelVersion) {
        try {
            return (String)getActiveVersionNumberQuery(name, modelVersion).getSingleResult();
        } catch (NonUniqueResultException e) {
            throw new IllegalStateException(
                    MessageFormat.format("There is more than one version marked as {0} for toc {1}, model version {2}",
                            Status.ACTIVE, name, modelVersion),
                    e);
        } catch (NoResultException e) {
            throw new IllegalArgumentException(
                    MessageFormat.format("There is no version marked as {0} for toc {1}, model version {2}",
                            Status.ACTIVE, name, modelVersion),
                    e);
        }
    }
}
