/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdata.jpa.provider;

import java.text.MessageFormat;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.faktorips.runtime.productdata.jpa.commons.AbstractProductDatabase;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity;
import org.faktorips.runtime.productdata.jpa.provider.ProductDatabase;

@Stateless
@Local(value={ProductDatabase.class})
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class ProductDatabaseBean
extends AbstractProductDatabase
implements ProductDatabase {
    public ProductDatabaseBean() {
    }

    public ProductDatabaseBean(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public TocVersionEntity getActiveTocVersion(String name, String modelVersion) {
        try {
            return (TocVersionEntity)this.getActiveTocVersionQuery(name, modelVersion).getSingleResult();
        }
        catch (NonUniqueResultException e) {
            throw new IllegalStateException(MessageFormat.format("There is more than one version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException(MessageFormat.format("There is no version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
    }

    @Override
    public String getActiveVersionNumber(String name, String modelVersion) {
        try {
            return (String)this.getActiveVersionNumberQuery(name, modelVersion).getSingleResult();
        }
        catch (NonUniqueResultException e) {
            throw new IllegalStateException(MessageFormat.format("There is more than one version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException(MessageFormat.format("There is no version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
    }
}

