/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.toc;

import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.productdata.jpa.commons.ContentContainer;
import org.faktorips.runtime.productdata.jpa.commons.GenerationTocEntryEntity;
import org.faktorips.runtime.productdata.jpa.util.DateTimeConverter;

public class DbGenerationTocEntry extends GenerationTocEntry implements DbTocEntryAdapter {

    private GenerationTocEntryEntity entity;

    public DbGenerationTocEntry(DbProductCmptTocEntry parent, GenerationTocEntryEntity entity) {
        super(parent, DateTimeConverter.toDateTime(entity.getValidFrom()),
                entity.getProductCmptEntry().getGenerationImplClassName(), null);
        this.entity = entity;
    }

    @Override
    public ContentContainer getContentContainer() {
        return entity;
    }

}
