/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.toc;

import static org.faktorips.runtime.productdata.jpa.util.DateTimeConverter.toDateTime;

import java.util.stream.Collectors;

import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.productdata.jpa.commons.ProductCmptTocEntryEntity;
import org.faktorips.runtime.productdata.jpa.commons.TocEntryEntity;

/**
 * An {@link ProductCmptTocEntry} reading its values from an {@link ProductCmptTocEntryEntity}.
 */
public class DbProductCmptTocEntry extends ProductCmptTocEntry implements DbTocEntryAdapter {

    private final ProductCmptTocEntryEntity entity;

    public DbProductCmptTocEntry(ProductCmptTocEntryEntity entity) {
        super(entity.getIpsObjectId(), entity.getIpsObjectQName(), entity.getKindId(), entity.getVersionId(), null,
                entity.getImplementationClassName(), entity.getGenerationImplClassName(),
                toDateTime(entity.getValidTo()));

        setGenerationEntries(entity.getGenerationEntries().stream()
                .map(g -> new DbGenerationTocEntry(this, g))
                .collect(Collectors.toList()));

        this.entity = entity;
    }

    @Override
    public TocEntryEntity getContentContainer() {
        return entity;
    }

}