/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.util;

import java.time.LocalDateTime;

import org.faktorips.runtime.internal.DateTime;

import edu.umd.cs.findbugs.annotations.CheckForNull;

public enum DateTimeConverter {
    /* util */;

    @CheckForNull
    public static DateTime toDateTime(@CheckForNull LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }

        return new DateTime(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(),
                localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }
}
