/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.toc;

import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.productdata.jpa.commons.ContentContainer;
import org.faktorips.runtime.productdata.jpa.commons.TableContentTocEntryEntity;

public class DbTableContentTocEntry extends TableContentTocEntry implements DbTocEntryAdapter {

    private final TableContentTocEntryEntity entity;

    public DbTableContentTocEntry(TableContentTocEntryEntity entity) {
        super(entity.getIpsObjectId(), entity.getIpsObjectQName(), null,
                entity.getImplementationClassName());
        this.entity = entity;
    }

    @Override
    public ContentContainer getContentContainer() {
        return entity;
    }

}