/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdata.jpa.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity;
import org.faktorips.runtime.productdata.jpa.provider.ProductDatabase;
import org.faktorips.runtime.productdata.jpa.toc.DbTableOfContents;
import org.faktorips.runtime.productdata.jpa.toc.DbTocEntryAdapter;
import org.faktorips.runtime.productdataprovider.AbstractProductDataProvider;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DbProductDataProvider
extends AbstractProductDataProvider {
    private final ProductDatabase productDatabase;
    private final DbTableOfContents toc;
    private final String version;
    private final TocVersionEntity tocVersion;

    public DbProductDataProvider(String name, String modelVersion, ProductDatabase productDatabase) {
        this(productDatabase.getActiveTocVersion(name, modelVersion), productDatabase);
    }

    public DbProductDataProvider(TocVersionEntity tocVersion, ProductDatabase productDatabase) {
        super(Objects::equals);
        this.tocVersion = tocVersion;
        this.productDatabase = productDatabase;
        this.toc = new DbTableOfContents(tocVersion);
        this.version = tocVersion.getVersion();
    }

    public InputStream getEnumContentAsStream(EnumContentTocEntry enumContentTocEntry) throws DataModifiedException {
        return this.getResourceAsStream((TocEntry)enumContentTocEntry);
    }

    private InputStream getResourceAsStream(TocEntry tocEntry) throws DataModifiedException {
        if (tocEntry instanceof DbTocEntryAdapter) {
            InputStream xmlContent = ((DbTocEntryAdapter)tocEntry).getXmlContent();
            this.throwExceptionIfModified(tocEntry, this.getBaseVersion());
            return xmlContent;
        }
        throw new IllegalArgumentException(tocEntry + " is no " + DbTocEntryAdapter.class.getName());
    }

    private void throwExceptionIfModified(TocEntry tocEntry, String currentVersion) throws DataModifiedException {
        if (!this.getVersionChecker().isCompatibleVersion(this.getVersion(), currentVersion)) {
            throw new DataModifiedException("Data has changed: " + this.getNameForExceptionText(tocEntry), this.getVersion(), currentVersion);
        }
    }

    private String getNameForExceptionText(TocEntry tocEntry) {
        if (tocEntry instanceof TocEntryObject) {
            return ((TocEntryObject)tocEntry).getIpsObjectId();
        }
        if (tocEntry instanceof GenerationTocEntry) {
            return ((GenerationTocEntry)tocEntry).getParent().getIpsObjectId();
        }
        return tocEntry.toString();
    }

    public Element getProductCmptData(ProductCmptTocEntry tocEntry) throws DataModifiedException {
        return this.getDocumentElement((TocEntry)tocEntry);
    }

    private Element getDocumentElement(TocEntry tocEntry) throws DataModifiedException {
        Element element;
        block9: {
            InputStream inputStream = this.getResourceAsStream(tocEntry);
            try {
                Document doc = this.getDocumentBuilder().parse(inputStream);
                Element element2 = doc.getDocumentElement();
                if (element2 == null) {
                    throw new RuntimeException("Xml resource for '" + tocEntry + "' hasn't got a document element.");
                }
                element = element2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new RuntimeException("Cannot parse xml resource for '" + tocEntry + "'", e);
                }
            }
            inputStream.close();
        }
        return element;
    }

    public Element getProductCmptGenerationData(GenerationTocEntry tocEntry) throws DataModifiedException {
        return this.getDocumentElement((TocEntry)tocEntry);
    }

    public InputStream getTableContentAsStream(TableContentTocEntry tocEntry) throws DataModifiedException {
        return this.getResourceAsStream((TocEntry)tocEntry);
    }

    public Element getTestcaseElement(TestCaseTocEntry arg0) throws DataModifiedException {
        throw new UnsupportedOperationException(CustomTocEntryObject.class.getName() + " is not supported in a " + DbProductDataProvider.class + " at the moment.");
    }

    public IReadonlyTableOfContents getToc() {
        return this.toc;
    }

    public <T> Element getTocEntryData(CustomTocEntryObject<T> arg0) throws DataModifiedException {
        throw new UnsupportedOperationException(CustomTocEntryObject.class.getName() + " is not supported in a " + DbProductDataProvider.class + " at the moment.");
    }

    public String getVersion() {
        return this.version;
    }

    public String getBaseVersion() {
        return this.productDatabase.getActiveVersionNumber(this.tocVersion.getName(), this.tocVersion.getModelVersion());
    }
}

