/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdata.jpa.toc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.faktorips.runtime.productdata.jpa.commons.EnumContentTocEntryEntity;
import org.faktorips.runtime.productdata.jpa.commons.ProductCmptTocEntryEntity;
import org.faktorips.runtime.productdata.jpa.commons.TableContentTocEntryEntity;
import org.faktorips.runtime.productdata.jpa.commons.TocEntryEntity;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity;
import org.faktorips.runtime.productdata.jpa.toc.DbEnumContentTocEntry;
import org.faktorips.runtime.productdata.jpa.toc.DbProductCmptTocEntry;
import org.faktorips.runtime.productdata.jpa.toc.DbTableContentTocEntry;

public class DbTableOfContents
implements IReadonlyTableOfContents {
    private String productDataVersion;
    private Map<String, DbEnumContentTocEntry> enumContentEntriesByEnumClass;
    private Map<String, DbTableContentTocEntry> tableContentEntriesByTableClass;
    private Map<String, DbTableContentTocEntry> tableContentEntriesByName;
    private Map<String, DbProductCmptTocEntry> productCmptEntriesByIpsObjectId;
    private Map<String, List<DbProductCmptTocEntry>> productCmptEntriesByKindIdAndVersionId;

    public DbTableOfContents(TocVersionEntity tocVersion) {
        this.productDataVersion = tocVersion.getModelVersion() + "-" + tocVersion.getVersion();
        Map<Class<? extends TocEntryEntity>, List<TocEntryEntity>> entriesByClass = tocVersion.getEntries().stream().collect(Collectors.groupingBy(Object::getClass));
        this.enumContentEntriesByEnumClass = DbTableOfContents.entriesByClass(entriesByClass, EnumContentTocEntryEntity.class).map(DbEnumContentTocEntry::new).collect(Collectors.toConcurrentMap(TocEntry::getImplementationClassName, Function.identity()));
        this.tableContentEntriesByName = DbTableOfContents.entriesByClass(entriesByClass, TableContentTocEntryEntity.class).map(DbTableContentTocEntry::new).collect(Collectors.toConcurrentMap(TocEntryObject::getIpsObjectQualifiedName, Function.identity()));
        this.tableContentEntriesByTableClass = this.tableContentEntriesByName.values().stream().collect(Collectors.toConcurrentMap(TocEntry::getImplementationClassName, Function.identity(), (a, b) -> a));
        this.productCmptEntriesByIpsObjectId = DbTableOfContents.entriesByClass(entriesByClass, ProductCmptTocEntryEntity.class).map(DbProductCmptTocEntry::new).collect(Collectors.toConcurrentMap(TocEntryObject::getIpsObjectId, Function.identity()));
        this.productCmptEntriesByKindIdAndVersionId = this.productCmptEntriesByIpsObjectId.values().stream().collect(Collectors.groupingBy(ProductCmptTocEntry::getKindId, ConcurrentHashMap::new, Collectors.toList()));
    }

    private static <T extends TocEntryEntity> Stream<T> entriesByClass(Map<Class<? extends TocEntryEntity>, List<TocEntryEntity>> entriesByClass, Class<T> tocEntryClass) {
        return entriesByClass.getOrDefault(tocEntryClass, List.of()).stream().map(tocEntryClass::cast);
    }

    @CheckForNull
    public ProductCmptTocEntry getProductCmptTocEntry(@CheckForNull String id) {
        return id == null ? null : (ProductCmptTocEntry)this.productCmptEntriesByIpsObjectId.get(id);
    }

    @CheckForNull
    public ProductCmptTocEntry getProductCmptTocEntry(@CheckForNull String kindId, @CheckForNull String versionId) {
        return this.getVersionEntries(kindId).flatMap(vs -> vs.stream().filter(v -> Objects.equals(versionId, v.getVersionId())).findFirst()).orElse(null);
    }

    private Optional<List<DbProductCmptTocEntry>> getVersionEntries(@CheckForNull String kindId) {
        return kindId == null ? Optional.empty() : Optional.ofNullable(this.productCmptEntriesByKindIdAndVersionId.get(kindId));
    }

    public List<ProductCmptTocEntry> getProductCmptTocEntries() {
        return new ArrayList<ProductCmptTocEntry>(this.productCmptEntriesByIpsObjectId.values());
    }

    public List<ProductCmptTocEntry> getProductCmptTocEntries(@CheckForNull String kindId) {
        return new ArrayList<ProductCmptTocEntry>(this.getVersionEntries(kindId).orElseGet(Collections::emptyList));
    }

    public List<TableContentTocEntry> getTableTocEntries() {
        return new ArrayList<TableContentTocEntry>(this.tableContentEntriesByTableClass.values());
    }

    @Deprecated
    public List<TestCaseTocEntry> getTestCaseTocEntries() {
        return List.of();
    }

    @Deprecated
    @CheckForNull
    public TestCaseTocEntry getTestCaseTocEntryByQName(@CheckForNull String qName) {
        return null;
    }

    @CheckForNull
    public TableContentTocEntry getTableTocEntryByClassname(@CheckForNull String implementationClass) {
        return implementationClass == null ? null : (TableContentTocEntry)this.tableContentEntriesByTableClass.get(implementationClass);
    }

    @CheckForNull
    public TableContentTocEntry getTableTocEntryByQualifiedTableName(@CheckForNull String qualifiedTableName) {
        return qualifiedTableName == null ? null : (TableContentTocEntry)this.tableContentEntriesByName.get(qualifiedTableName);
    }

    @Deprecated
    public Set<ModelTypeTocEntry> getModelTypeTocEntries() {
        return Set.of();
    }

    public List<EnumContentTocEntry> getEnumContentTocEntries() {
        return new ArrayList<EnumContentTocEntry>(this.enumContentEntriesByEnumClass.values());
    }

    @CheckForNull
    public EnumContentTocEntry getEnumContentTocEntry(@CheckForNull String className) {
        return className == null ? null : (EnumContentTocEntry)this.enumContentEntriesByEnumClass.get(className);
    }

    @Deprecated
    public Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries() {
        return Set.of();
    }

    public String getProductDataVersion() {
        return this.productDataVersion;
    }

    @Deprecated
    @CheckForNull
    public <T> CustomTocEntryObject<T> getCustomTocEntry(@CheckForNull Class<T> type, @CheckForNull String ipsObjectQualifiedName) {
        return null;
    }
}

