/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdata.jpa.provider;

import jakarta.ejb.Local;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import java.text.MessageFormat;
import org.faktorips.runtime.productdata.jpa.commons.AbstractProductDatabase;
import org.faktorips.runtime.productdata.jpa.commons.TocVersionEntity;
import org.faktorips.runtime.productdata.jpa.provider.ProductDatabase;

@Stateless
@Local(value={ProductDatabase.class})
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class ProductDatabaseBean
extends AbstractProductDatabase
implements ProductDatabase {
    public ProductDatabaseBean() {
    }

    public ProductDatabaseBean(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public TocVersionEntity getActiveTocVersion(String name, String modelVersion) {
        try {
            return (TocVersionEntity)this.getActiveTocVersionQuery(name, modelVersion).getSingleResult();
        }
        catch (NonUniqueResultException e) {
            throw new IllegalStateException(MessageFormat.format("There is more than one version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException(MessageFormat.format("There is no version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
    }

    @Override
    public String getActiveVersionNumber(String name, String modelVersion) {
        try {
            return (String)this.getActiveVersionNumberQuery(name, modelVersion).getSingleResult();
        }
        catch (NonUniqueResultException e) {
            throw new IllegalStateException(MessageFormat.format("There is more than one version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException(MessageFormat.format("There is no version marked as {0} for toc {1}, model version {2}", TocVersionEntity.Status.ACTIVE, name, modelVersion), e);
        }
    }
}

