/*******************************************************************************
 * Copyright (c) Faktor Zehn GmbH - faktorzehn.org
 * 
 * This source code is available under the terms of the AGPL Affero General Public License version
 * 3.
 * 
 * Please see LICENSE.txt for full license terms, including the additional permissions and
 * restrictions as well as the possibility of alternative license terms.
 *******************************************************************************/
package org.faktorips.runtime.productdata.jpa.toc;

import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.productdata.jpa.commons.EnumContentTocEntryEntity;
import org.faktorips.runtime.productdata.jpa.commons.TocEntryEntity;

/**
 * An {@link EnumContentTocEntry} reading its values from an {@link EnumContentTocEntryEntity}.
 */
public class DbEnumContentTocEntry extends EnumContentTocEntry implements DbTocEntryAdapter {

    private final EnumContentTocEntryEntity entity;

    public DbEnumContentTocEntry(EnumContentTocEntryEntity entity) {
        super(entity.getIpsObjectId(), entity.getIpsObjectQName(), null,
                entity.getImplementationClassName());
        this.entity = entity;
    }

    @Override
    public TocEntryEntity getContentContainer() {
        return entity;
    }

}