/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import com.google.gson.Gson;
import io.jsonwebtoken.Jwts;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.fanout.gripcontrol.Channel;
import org.fanout.gripcontrol.Response;
import org.fanout.gripcontrol.Utilities;
import org.fanout.gripcontrol.WebSocketEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GripControl {
    public static String createHold(String mode, List<Channel> channels, Response response, int timeout) {
        HashMap<String, Object> hold = new HashMap<String, Object>();
        hold.put("mode", mode);
        List<Map<String, Object>> holdChannels = GripControl.getHoldChannels(channels);
        hold.put("channels", holdChannels);
        if (timeout > 0) {
            hold.put("timeout", timeout);
        }
        HashMap<String, Map<String, Object>> instruct = new HashMap<String, Map<String, Object>>();
        instruct.put("hold", hold);
        Map<String, Object> holdResponse = GripControl.getHoldResponse(response);
        if (holdResponse != null) {
            instruct.put("response", holdResponse);
        }
        return new Gson().toJson(instruct);
    }

    public static String createHoldResponse(List<Channel> channels) {
        return GripControl.createHold("response", channels, null, 0);
    }

    public static String createHoldResponse(List<Channel> channels, Response response) {
        return GripControl.createHold("response", channels, response, 0);
    }

    public static String createHoldResponse(List<Channel> channels, Response response, int timeout) {
        return GripControl.createHold("response", channels, response, timeout);
    }

    public static String createHoldStream(List<Channel> channels) {
        return GripControl.createHold("stream", channels, null, 0);
    }

    public static String createHoldStream(List<Channel> channels, Response response) {
        return GripControl.createHold("stream", channels, response, 0);
    }

    public static String createGripChannelHeader(List<Channel> channels) {
        String header = "";
        for (Channel channel : channels) {
            if (header != "") {
                header = header + ", ";
            }
            header = header + channel.name;
            if (channel.prevId == null) continue;
            header = header + "; prev-id=" + channel.prevId;
        }
        return header;
    }

    public static String webSocketControlMessage(String type) {
        return GripControl.webSocketControlMessage(type, null);
    }

    public static String webSocketControlMessage(String type, Map<String, Object> args) {
        Map<String, Object> out = args != null ? args : new HashMap<String, Object>();
        out.put("type", type);
        String message = new Gson().toJson(out);
        out.remove("type");
        return message;
    }

    public static Map<String, Object> parseGripUri(String uri) throws UnsupportedEncodingException, MalformedURLException {
        HashMap<String, Object> out = new HashMap<String, Object>();
        URL url = new URL(uri);
        Map<String, List<String>> params = Utilities.splitQuery(url);
        String iss = "";
        List<String> issQueryValue = params.get("iss");
        if (issQueryValue != null) {
            iss = issQueryValue.get(0);
            params.remove("iss");
        }
        String key = "";
        List<String> keyQueryValue = params.get("key");
        if (keyQueryValue != null) {
            key = keyQueryValue.get(0);
            params.remove("key");
        }
        if (key != null && key.startsWith("base64:")) {
            key = new String(DatatypeConverter.parseBase64Binary((String)key.substring(7)));
        }
        String queryString = "";
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            if (queryString != "") {
                queryString = queryString + "&";
            }
            queryString = queryString + URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue().get(0), "UTF-8");
        }
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String port = "";
        if (url.getPort() > -1 && url.getPort() != 80) {
            port = ":" + Integer.toString(url.getPort());
        }
        String controlUri = url.getProtocol() + "://" + url.getHost() + port + path;
        if (queryString != "") {
            controlUri = controlUri + "?" + queryString;
        }
        out.put("control_uri", controlUri);
        if (iss != "") {
            out.put("control_iss", iss);
        }
        if (key != "") {
            out.put("key", key);
        }
        return out;
    }

    public static boolean validateSig(String token, String key) {
        try {
            Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)key)).parseClaimsJws(token).getBody();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String encodeWebSocketEvents(List<WebSocketEvent> webSocketEvents) {
        String out = "";
        for (WebSocketEvent event : webSocketEvents) {
            out = out + event.type;
            if (event.content != null) {
                out = out + " " + Integer.toString(event.content.length(), 16) + "\r\n" + event.content + "\r\n";
                continue;
            }
            out = out + "\r\n";
        }
        return out;
    }

    public static List<WebSocketEvent> decodeWebSocketEvents(String body) {
        ArrayList<WebSocketEvent> events = new ArrayList<WebSocketEvent>();
        int start = 0;
        while (start < body.length()) {
            int at = body.indexOf("\r\n", start);
            if (at == -1) {
                throw new IllegalArgumentException("bad format");
            }
            String typeline = body.substring(start, at);
            start = at + 2;
            at = typeline.indexOf(" ");
            WebSocketEvent event = null;
            if (at >= 0) {
                String etype = typeline.substring(0, at);
                int clen = Integer.parseInt(typeline.substring(at + 1, typeline.length()), 16);
                String content = body.substring(start, start + clen);
                start += clen + 2;
                event = new WebSocketEvent(etype, content);
            } else {
                event = new WebSocketEvent(typeline);
            }
            events.add(event);
        }
        return events;
    }

    private static List<Map<String, Object>> getHoldChannels(List<Channel> channels) {
        ArrayList<Map<String, Object>> holdChannels = new ArrayList<Map<String, Object>>();
        for (Channel channel : channels) {
            HashMap<String, String> holdChannel = new HashMap<String, String>();
            holdChannel.put("name", channel.name);
            if (channel.prevId != null) {
                holdChannel.put("prev-id", channel.prevId);
            }
            holdChannels.add(holdChannel);
        }
        return holdChannels;
    }

    private static Map<String, Object> getHoldResponse(Response response) {
        if (response == null) {
            return null;
        }
        HashMap<String, Object> holdResponse = new HashMap<String, Object>();
        if (response.code != null) {
            holdResponse.put("code", response.code);
        }
        if (response.reason != null) {
            holdResponse.put("reason", response.reason);
        }
        if (response.headers != null) {
            holdResponse.put("headers", response.headers);
        }
        if (response.body != null) {
            if (Utilities.isUtf8(response.body)) {
                try {
                    holdResponse.put("body", new String(response.body, "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                holdResponse.put("body-bin", DatatypeConverter.printBase64Binary((byte[])response.body));
            }
        }
        return holdResponse;
    }
}

