/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.fanout.gripcontrol.Utilities;
import org.fanout.pubcontrol.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseFormat
implements Format {
    public byte[] body;
    public Map<String, String> headers;
    public String code;
    public String reason;

    public HttpResponseFormat(String body) throws UnsupportedEncodingException {
        this.body = body.getBytes("utf-8");
    }

    public HttpResponseFormat(String body, Map<String, String> headers, String code, String reason) throws UnsupportedEncodingException {
        this.body = body.getBytes("utf-8");
        this.headers = headers;
        this.code = code;
        this.reason = reason;
    }

    public HttpResponseFormat(byte[] body) {
        this.body = body;
    }

    public HttpResponseFormat(byte[] body, Map<String, String> headers, String code, String reason) {
        this.body = body;
        this.headers = headers;
        this.code = code;
        this.reason = reason;
    }

    public String name() {
        return "http-response";
    }

    public Object export() {
        HashMap<String, Object> export = new HashMap<String, Object>();
        if (this.code != null) {
            export.put("code", this.code);
        }
        if (this.reason != null) {
            export.put("reason", this.reason);
        }
        if (this.headers != null) {
            export.put("headers", this.headers);
        }
        if (this.body != null) {
            if (Utilities.isUtf8(this.body)) {
                try {
                    export.put("body", new String(this.body, "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                export.put("body-bin", DatatypeConverter.printBase64Binary((byte[])this.body));
            }
        }
        return export;
    }
}

