/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static int charLength(byte[] bytes) {
        int charCount = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int expectedLen;
            ++charCount;
            if ((bytes[i] & Integer.parseInt("10000000", 2)) == Integer.parseInt("00000000", 2)) continue;
            if ((bytes[i] & Integer.parseInt("11100000", 2)) == Integer.parseInt("11000000", 2)) {
                expectedLen = 2;
            } else if ((bytes[i] & Integer.parseInt("11110000", 2)) == Integer.parseInt("11100000", 2)) {
                expectedLen = 3;
            } else if ((bytes[i] & Integer.parseInt("11111000", 2)) == Integer.parseInt("11110000", 2)) {
                expectedLen = 4;
            } else if ((bytes[i] & Integer.parseInt("11111100", 2)) == Integer.parseInt("11111000", 2)) {
                expectedLen = 5;
            } else if ((bytes[i] & Integer.parseInt("11111110", 2)) == Integer.parseInt("11111100", 2)) {
                expectedLen = 6;
            } else {
                return -1;
            }
            while (--expectedLen > 0) {
                if (++i >= bytes.length) {
                    return -1;
                }
                if ((bytes[i] & Integer.parseInt("11000000", 2)) == Integer.parseInt("10000000", 2)) continue;
                return -1;
            }
        }
        return charCount;
    }

    public static boolean isUtf8(byte[] bytes) {
        return Utilities.charLength(bytes) != -1;
    }

    public static Map<String, List<String>> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        String query = url.getQuery();
        if (query == null) {
            return queryPairs;
        }
        for (String pair : pairs = query.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)queryPairs.get(key)).add(value);
        }
        return queryPairs;
    }
}

