/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import org.fanout.gripcontrol.HttpStreamAction;
import org.fanout.gripcontrol.Utilities;
import org.fanout.pubcontrol.Format;

public class HttpStreamFormat
implements Format {
    public byte[] content;
    public Boolean isClose = false;

    public HttpStreamFormat(HttpStreamAction action) throws IllegalArgumentException {
        if (action == HttpStreamAction.CLOSE) {
            this.isClose = true;
        }
    }

    public HttpStreamFormat(String content) throws UnsupportedEncodingException, IllegalArgumentException {
        this.content = content.getBytes("utf-8");
        this.verifyContent();
    }

    public HttpStreamFormat(byte[] content) throws IllegalArgumentException {
        this.content = content;
        this.verifyContent();
    }

    public String name() {
        return "http-stream";
    }

    public Object export() {
        HashMap<String, String> export = new HashMap<String, String>();
        if (this.isClose.booleanValue()) {
            export.put("action", "close");
        } else if (Utilities.isUtf8(this.content)) {
            try {
                export.put("content", new String(this.content, "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            export.put("content-bin", DatatypeConverter.printBase64Binary((byte[])this.content));
        }
        return export;
    }

    private void verifyContent() throws IllegalArgumentException {
        if (!(this.isClose.booleanValue() || this.content != null && this.content.length != 0)) {
            throw new IllegalArgumentException("Content must be set");
        }
    }
}

