/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fanout.gripcontrol.HttpResponseFormat;
import org.fanout.gripcontrol.HttpStreamFormat;
import org.fanout.pubcontrol.Format;
import org.fanout.pubcontrol.Item;
import org.fanout.pubcontrol.PubControl;
import org.fanout.pubcontrol.PubControlClient;
import org.fanout.pubcontrol.PublishCallback;
import org.fanout.pubcontrol.PublishFailedException;

public class GripPubControl
extends PubControl {
    public GripPubControl() {
        super(null);
    }

    public GripPubControl(List<Map<String, Object>> config) {
        super(null);
        if (config != null) {
            this.applyGripConfig(config);
        }
    }

    public void applyGripConfig(List<Map<String, Object>> config) {
        for (Map<String, Object> entry : config) {
            String uri = null;
            if (entry.get("control_uri") != null) {
                uri = (String)entry.get("control_uri");
            }
            PubControlClient client = new PubControlClient(uri);
            Object iss = entry.get("control_iss");
            Object key = entry.get("key");
            if (iss != null && key != null) {
                HashMap<String, String> claims = new HashMap<String, String>();
                claims.put("iss", (String)iss);
                client.setAuthJwt(claims, (byte[])key);
            } else if (key != null) {
                client.setAuthBearer((String)key);
            }
            super.addClient(client);
        }
    }

    public void publishHttpResponse(List<String> channels, HttpResponseFormat format, String id, String prevId) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(format), id, prevId));
    }

    public void publishHttpResponse(List<String> channels, String body, String id, String prevId) throws PublishFailedException, UnsupportedEncodingException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), id, prevId));
    }

    public void publishHttpResponse(List<String> channels, byte[] body, String id, String prevId) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), id, prevId));
    }

    public void publishHttpResponse(List<String> channels, HttpResponseFormat format) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(format), null, null));
    }

    public void publishHttpResponse(List<String> channels, String body) throws PublishFailedException, UnsupportedEncodingException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), null, null));
    }

    public void publishHttpResponse(List<String> channels, byte[] body) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), null, null));
    }

    public void publishHttpResponseAsync(List<String> channels, HttpResponseFormat format, String id, String prevId, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(format), id, prevId), callback);
    }

    public void publishHttpResponseAsync(List<String> channels, String body, String id, String prevId, PublishCallback callback) throws UnsupportedEncodingException {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), id, prevId), callback);
    }

    public void publishHttpResponseAsync(List<String> channels, byte[] body, String id, String prevId, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), id, prevId), callback);
    }

    public void publishHttpResponseAsync(List<String> channels, HttpResponseFormat format, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(format), null, null), callback);
    }

    public void publishHttpResponseAsync(List<String> channels, String body, PublishCallback callback) throws UnsupportedEncodingException {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), null, null), callback);
    }

    public void publishHttpResponseAsync(List<String> channels, byte[] body, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpResponseFormat(body)), null, null), callback);
    }

    public void publishHttpStream(List<String> channels, HttpStreamFormat format, String id, String prevId) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(format), id, prevId));
    }

    public void publishHttpStream(List<String> channels, String content, String id, String prevId) throws PublishFailedException, UnsupportedEncodingException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), id, prevId));
    }

    public void publishHttpStream(List<String> channels, byte[] content, String id, String prevId) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), id, prevId));
    }

    public void publishHttpStream(List<String> channels, HttpStreamFormat format) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(format), null, null));
    }

    public void publishHttpStream(List<String> channels, String content) throws PublishFailedException, UnsupportedEncodingException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), null, null));
    }

    public void publishHttpStream(List<String> channels, byte[] content) throws PublishFailedException {
        super.publish(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), null, null));
    }

    public void publishHttpStreamAsync(List<String> channels, HttpStreamFormat format, String id, String prevId, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(format), id, prevId), callback);
    }

    public void publishHttpStreamAsync(List<String> channels, String content, String id, String prevId, PublishCallback callback) throws UnsupportedEncodingException {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), id, prevId), callback);
    }

    public void publishHttpStreamAsync(List<String> channels, byte[] content, String id, String prevId, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), id, prevId), callback);
    }

    public void publishHttpStreamAsync(List<String> channels, HttpStreamFormat format, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(format), null, null), callback);
    }

    public void publishHttpStreamAsync(List<String> channels, String content, PublishCallback callback) throws UnsupportedEncodingException {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), null, null), callback);
    }

    public void publishHttpStreamAsync(List<String> channels, byte[] content, PublishCallback callback) {
        super.publishAsync(channels, new Item(this.getListOfFormats(new HttpStreamFormat(content)), null, null), callback);
    }

    private List<Format> getListOfFormats(Format format) {
        ArrayList<Format> formats = new ArrayList<Format>();
        formats.add(format);
        return formats;
    }
}

