/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Utilities {
    public static String utf8BytesToString(byte[] bytes) {
        String asString;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            CharBuffer charBuffer = decoder.decode(buffer);
            asString = charBuffer.toString();
        }
        catch (CharacterCodingException ex) {
            asString = null;
        }
        return asString;
    }

    public static int charLength(byte[] bytes) {
        String asString = Utilities.utf8BytesToString(bytes);
        if (asString == null) {
            return -1;
        }
        return asString.length();
    }

    public static boolean isUtf8(byte[] bytes) {
        return Utilities.utf8BytesToString(bytes) != null;
    }

    public static Map<String, List<String>> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> queryPairs = new LinkedHashMap<String, List<String>>();
        String query = url.getQuery();
        if (query == null) {
            return queryPairs;
        }
        for (String pair : pairs = query.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)queryPairs.get(key)).add(value);
        }
        return queryPairs;
    }
}

