/*
 * Decompiled with CFR 0.152.
 */
package org.fanout.gripcontrol;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public class WebSocketEvent {
    public String type;
    public final String content;
    public final byte[] contentBytes;

    public WebSocketEvent(String type) {
        this.type = type;
        this.content = null;
        this.contentBytes = null;
    }

    public WebSocketEvent(String type, String content) {
        this.type = type;
        this.content = content;
        this.contentBytes = content.getBytes();
    }

    public WebSocketEvent(String type, byte[] contentBytes) {
        String asString;
        this.type = type;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(contentBytes);
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            CharBuffer charBuffer = decoder.decode(buffer);
            asString = charBuffer.toString();
        }
        catch (CharacterCodingException ex) {
            asString = null;
        }
        this.content = asString;
        this.contentBytes = contentBytes;
    }
}

