/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;
import org.apache.clerezza.rdf.jena.serializer.JenaSerializerProvider;
import org.fcrepo.audit.AuditUtils;
import org.fcrepo.camel.processor.ProcessorUtils;

public class AuditSparqlProcessor
implements Processor {
    private static final UriRef INTERNAL_EVENT = new UriRef("http://fedora.info/definitions/v4/audit#InternalEvent");
    private static final UriRef PREMIS_EVENT = new UriRef("http://www.loc.gov/premis/rdf/v1#Event");
    private static final UriRef PROV_EVENT = new UriRef("http://www.w3.org/ns/prov#InstantaneousEvent");
    private static final UriRef PREMIS_TIME = new UriRef("http://www.loc.gov/premis/rdf/v1#hasEventDateTime");
    private static final UriRef PREMIS_OBJ = new UriRef("http://www.loc.gov/premis/rdf/v1#hasEventRelatedObject");
    private static final UriRef PREMIS_AGENT = new UriRef("http://www.loc.gov/premis/rdf/v1#hasEventRelatedAgent");
    private static final UriRef PREMIS_TYPE = new UriRef("http://www.loc.gov/premis/rdf/v1#hasEventType");
    private static final UriRef RDF_TYPE = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final UriRef XSD_DATE = new UriRef("http://www.w3.org/2001/XMLSchema#dateTime");
    private static final UriRef XSD_STRING = new UriRef("http://www.w3.org/2001/XMLSchema#string");
    private static final String EMPTY_STRING = "";

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String eventURIBase = (String)in.getHeader("CamelAuditEventBaseUri", String.class);
        String eventID = (String)in.getHeader("org.fcrepo.jms.eventID", String.class);
        UriRef eventURI = new UriRef(eventURIBase + "/" + eventID);
        Set<Triple> triples = AuditSparqlProcessor.triplesForMessage(in, eventURI);
        JenaSerializerProvider serializer = new JenaSerializerProvider();
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        serializer.serialize((OutputStream)serializedGraph, (TripleCollection)new SimpleMGraph(triples), "text/rdf+nt");
        StringBuilder query = new StringBuilder("update=");
        query.append(ProcessorUtils.insertData((String)serializedGraph.toString("UTF-8"), null));
        in.setBody((Object)query.toString());
        in.setHeader("CamelAuditEventUri", (Object)eventURI.toString());
        in.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        in.setHeader("CamelHttpMethod", (Object)"POST");
    }

    private static Set<Triple> triplesForMessage(Message message, UriRef subject) throws IOException {
        String eventType = (String)message.getHeader("org.fcrepo.jms.eventType", (Object)EMPTY_STRING);
        Long timestamp = (Long)message.getHeader("org.fcrepo.jms.timestamp", (Object)0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = df.format(new Date(timestamp));
        String user = (String)message.getHeader("org.fcrepo.jms.user", (Object)EMPTY_STRING);
        String agent = (String)message.getHeader("org.fcrepo.jms.userAgent", (Object)EMPTY_STRING);
        String properties = (String)message.getHeader("org.fcrepo.jms.properties", (Object)EMPTY_STRING);
        String identifier = ProcessorUtils.getSubjectUri((Message)message);
        String premisType = AuditUtils.getAuditEventType((String)eventType, (String)properties);
        HashSet<Triple> triples = new HashSet<Triple>();
        triples.add((Triple)new TripleImpl((NonLiteral)subject, RDF_TYPE, (Resource)INTERNAL_EVENT));
        triples.add((Triple)new TripleImpl((NonLiteral)subject, RDF_TYPE, (Resource)PREMIS_EVENT));
        triples.add((Triple)new TripleImpl((NonLiteral)subject, RDF_TYPE, (Resource)PROV_EVENT));
        triples.add((Triple)new TripleImpl((NonLiteral)subject, PREMIS_TIME, (Resource)new TypedLiteralImpl(date, XSD_DATE)));
        triples.add((Triple)new TripleImpl((NonLiteral)subject, PREMIS_OBJ, (Resource)new UriRef(identifier)));
        triples.add((Triple)new TripleImpl((NonLiteral)subject, PREMIS_AGENT, (Resource)new TypedLiteralImpl(user, XSD_STRING)));
        triples.add((Triple)new TripleImpl((NonLiteral)subject, PREMIS_AGENT, (Resource)new TypedLiteralImpl(agent, XSD_STRING)));
        if (premisType != null) {
            triples.add((Triple)new TripleImpl((NonLiteral)subject, PREMIS_TYPE, (Resource)new UriRef(premisType)));
        }
        return triples;
    }
}

