/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fcrepo.audit.AuditUtils;
import org.fcrepo.camel.processor.ProcessorUtils;

public class AuditSparqlProcessor
implements Processor {
    private static final Resource INTERNAL_EVENT = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/audit#InternalEvent");
    private static final Resource PREMIS_EVENT = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#Event");
    private static final Resource PROV_EVENT = ResourceFactory.createResource((String)"http://www.w3.org/ns/prov#InstantaneousEvent");
    private static final Property PREMIS_TIME = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventDateTime");
    private static final Property PREMIS_OBJ = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventRelatedObject");
    private static final Property PREMIS_AGENT = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventRelatedAgent");
    private static final Property PREMIS_TYPE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventType");
    private static final Property RDF_TYPE = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final String EMPTY_STRING = "";

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String eventURIBase = (String)in.getHeader("CamelAuditEventBaseUri", String.class);
        String eventID = (String)in.getHeader("org.fcrepo.jms.eventID", String.class);
        Resource eventURI = ResourceFactory.createResource((String)(eventURIBase + "/" + eventID));
        StringBuilder query = new StringBuilder("update=");
        query.append(ProcessorUtils.insertData((String)AuditSparqlProcessor.serializedGraphForMessage(in, eventURI), null));
        in.setBody((Object)query.toString());
        in.setHeader("CamelAuditEventUri", (Object)eventURI.toString());
        in.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        in.setHeader("CamelHttpMethod", (Object)"POST");
    }

    private static String serializedGraphForMessage(Message message, Resource subject) throws IOException {
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        Model model = ModelFactory.createDefaultModel();
        String eventType = (String)message.getHeader("org.fcrepo.jms.eventType", (Object)EMPTY_STRING);
        Long timestamp = (Long)message.getHeader("org.fcrepo.jms.timestamp", (Object)0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = df.format(new Date(timestamp));
        String user = (String)message.getHeader("org.fcrepo.jms.user", (Object)EMPTY_STRING);
        String agent = (String)message.getHeader("org.fcrepo.jms.userAgent", (Object)EMPTY_STRING);
        String properties = (String)message.getHeader("org.fcrepo.jms.properties", (Object)EMPTY_STRING);
        String identifier = ProcessorUtils.getSubjectUri((Message)message);
        String premisType = AuditUtils.getAuditEventType((String)eventType, (String)properties);
        model.add(model.createStatement(subject, RDF_TYPE, (RDFNode)INTERNAL_EVENT));
        model.add(model.createStatement(subject, RDF_TYPE, (RDFNode)PREMIS_EVENT));
        model.add(model.createStatement(subject, RDF_TYPE, (RDFNode)PROV_EVENT));
        model.add(model.createStatement(subject, PREMIS_TIME, (RDFNode)ResourceFactory.createTypedLiteral((String)date, (RDFDatatype)XSDDatatype.XSDdateTime)));
        model.add(model.createStatement(subject, PREMIS_OBJ, (RDFNode)ResourceFactory.createResource((String)identifier)));
        model.add(model.createStatement(subject, PREMIS_AGENT, (RDFNode)ResourceFactory.createTypedLiteral((String)user, (RDFDatatype)XSDDatatype.XSDstring)));
        model.add(model.createStatement(subject, PREMIS_AGENT, (RDFNode)ResourceFactory.createTypedLiteral((String)agent, (RDFDatatype)XSDDatatype.XSDstring)));
        if (premisType != null) {
            model.add(model.createStatement(subject, PREMIS_TYPE, (RDFNode)ResourceFactory.createResource((String)premisType)));
        }
        model.write((OutputStream)serializedGraph, "N-TRIPLE");
        return serializedGraph.toString("UTF-8");
    }
}

