/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.audit.triplestore.AuditSparqlProcessor;

public class EventRouter
extends RouteBuilder {
    public void configure() throws Exception {
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Event Routing Error: ${routeId}");
        this.from("{{input.stream}}").routeId("AuditFcrepoRouter").filter(PredicateBuilder.not((Predicate)PredicateBuilder.or((Predicate)this.header("org.fcrepo.jms.identifier").startsWith((Object)this.simple("{{audit.container}}/")), (Predicate)this.header("org.fcrepo.jms.identifier").isEqualTo((Object)this.simple("{{audit.container}}"))))).to("direct:event");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:event").routeId("AuditEventRouter").setHeader("CamelAuditEventBaseUri", (Expression)this.simple("{{event.baseUri}}"))).process((Processor)new AuditSparqlProcessor())).log(LoggingLevel.INFO, "org.fcrepo.camel.audit", "Audit Event: ${headers[org.fcrepo.jms.identifier]} :: ${headers[CamelAuditEventUri]}")).to("http4:{{triplestore.baseUrl}}");
    }
}

