/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.fcrepo.camel.processor.ProcessorUtils;

public class AuditSparqlProcessor
implements Processor {
    static final String AUDIT = "http://fedora.info/definitions/v4/audit#";
    static final String PREMIS = "http://www.loc.gov/premis/rdf/v1#";
    static final String PROV = "http://www.w3.org/ns/prov#";
    static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    static final String EVENT_TYPE = "http://id.loc.gov/vocabulary/preservation/eventType/";
    static final String EVENT_NAMESPACE = "http://fedora.info/definitions/v4/event#";
    static final String CONTENT_MOD = "http://fedora.info/definitions/v4/audit#contentModification";
    static final String CONTENT_REM = "http://fedora.info/definitions/v4/audit#contentRemoval";
    static final String METADATA_MOD = "http://fedora.info/definitions/v4/audit#metadataModification";
    static final String CONTENT_ADD = "http://id.loc.gov/vocabulary/preservation/eventType/ing";
    static final String OBJECT_ADD = "http://id.loc.gov/vocabulary/preservation/eventType/cre";
    static final String OBJECT_REM = "http://id.loc.gov/vocabulary/preservation/eventType/del";
    static final String HAS_CONTENT = "http://fedora.info/definitions/v4/repository#hasContent";
    static final String NODE_ADDED = "http://fedora.info/definitions/v4/repository#NODE_ADDED";
    static final String NODE_REMOVED = "http://fedora.info/definitions/v4/repository#NODE_REMOVED";
    static final String PROPERTY_CHANGED = "http://fedora.info/definitions/v4/repository#PROPERTY_CHANGED";
    private static final Resource INTERNAL_EVENT = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/audit#InternalEvent");
    private static final Resource PREMIS_EVENT = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#Event");
    private static final Resource PROV_EVENT = ResourceFactory.createResource((String)"http://www.w3.org/ns/prov#InstantaneousEvent");
    private static final Property PREMIS_TIME = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventDateTime");
    private static final Property PREMIS_OBJ = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventRelatedObject");
    private static final Property PREMIS_AGENT = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventRelatedAgent");
    private static final Property PREMIS_TYPE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasEventType");
    private static final Property RDF_TYPE = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final String EMPTY_STRING = "";
    private static final String RESOURCE_TYPES = "org.fcrepo.jms.resourceType";

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String eventURIBase = (String)in.getHeader("CamelAuditEventBaseUri", String.class);
        String eventID = (String)in.getHeader("org.fcrepo.jms.eventID", String.class);
        Resource eventURI = ResourceFactory.createResource((String)(eventURIBase + "/" + eventID));
        StringBuilder query = new StringBuilder("update=");
        query.append(ProcessorUtils.insertData((String)AuditSparqlProcessor.serializedGraphForMessage(in, eventURI), null));
        in.setBody((Object)query.toString());
        in.setHeader("CamelAuditEventUri", (Object)eventURI.toString());
        in.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        in.setHeader("CamelHttpMethod", (Object)"POST");
    }

    private static String serializedGraphForMessage(Message message, Resource subject) throws IOException {
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        Model model = ModelFactory.createDefaultModel();
        String eventType = (String)message.getHeader("org.fcrepo.jms.eventType", (Object)EMPTY_STRING, String.class);
        Long timestamp = (Long)message.getHeader("org.fcrepo.jms.timestamp", (Object)0, Long.class);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = df.format(new Date(timestamp));
        String user = (String)message.getHeader("org.fcrepo.jms.user", (Object)EMPTY_STRING, String.class);
        String agent = (String)message.getHeader("org.fcrepo.jms.userAgent", (Object)EMPTY_STRING, String.class);
        String properties = (String)message.getHeader("org.fcrepo.jms.properties", (Object)EMPTY_STRING, String.class);
        String resourceTypes = (String)message.getHeader(RESOURCE_TYPES, (Object)EMPTY_STRING, String.class);
        String identifier = ProcessorUtils.getSubjectUri((Message)message);
        String premisType = AuditSparqlProcessor.getAuditEventType(eventType, properties, resourceTypes);
        model.add(model.createStatement(subject, RDF_TYPE, (RDFNode)INTERNAL_EVENT));
        model.add(model.createStatement(subject, RDF_TYPE, (RDFNode)PREMIS_EVENT));
        model.add(model.createStatement(subject, RDF_TYPE, (RDFNode)PROV_EVENT));
        model.add(model.createStatement(subject, PREMIS_TIME, (RDFNode)ResourceFactory.createTypedLiteral((String)date, (RDFDatatype)XSDDatatype.XSDdateTime)));
        model.add(model.createStatement(subject, PREMIS_OBJ, (RDFNode)ResourceFactory.createResource((String)identifier)));
        model.add(model.createStatement(subject, PREMIS_AGENT, (RDFNode)ResourceFactory.createTypedLiteral((String)user, (RDFDatatype)XSDDatatype.XSDstring)));
        model.add(model.createStatement(subject, PREMIS_AGENT, (RDFNode)ResourceFactory.createTypedLiteral((String)agent, (RDFDatatype)XSDDatatype.XSDstring)));
        if (premisType != null) {
            model.add(model.createStatement(subject, PREMIS_TYPE, (RDFNode)ResourceFactory.createResource((String)premisType)));
        }
        model.write((OutputStream)serializedGraph, "N-TRIPLE");
        return serializedGraph.toString("UTF-8");
    }

    private static String getAuditEventType(String eventType, String properties, String resourceType) {
        if (eventType.contains(NODE_ADDED) || eventType.contains("http://fedora.info/definitions/v4/event#ResourceCreation")) {
            if (properties != null && properties.contains(HAS_CONTENT)) {
                return CONTENT_ADD;
            }
            if (resourceType != null && resourceType.contains("http://fedora.info/definitions/v4/repository#Binary")) {
                return CONTENT_ADD;
            }
            return OBJECT_ADD;
        }
        if (eventType.contains(NODE_REMOVED) || eventType.contains("http://fedora.info/definitions/v4/event#ResourceDeletion")) {
            if (properties != null && properties.contains(HAS_CONTENT)) {
                return CONTENT_REM;
            }
            if (resourceType != null && resourceType.contains("http://fedora.info/definitions/v4/repository#Binary")) {
                return CONTENT_REM;
            }
            return OBJECT_REM;
        }
        if (eventType.contains(PROPERTY_CHANGED) || eventType.contains("http://fedora.info/definitions/v4/event#ResourceModification")) {
            if (properties != null && properties.contains(HAS_CONTENT)) {
                return CONTENT_MOD;
            }
            if (resourceType != null && resourceType.contains("http://fedora.info/definitions/v4/repository#Binary")) {
                return CONTENT_MOD;
            }
            return METADATA_MOD;
        }
        return null;
    }
}

