/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.audit.triplestore;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.http.HttpComponent;
import org.fcrepo.camel.audit.triplestore.EventRouter;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.fcrepo.camel.common.config.ConditionOnPropertyTrue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={AuditTriplestoreEnabled.class})
public class FcrepoAuditTriplestoreConfig
extends BasePropsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoAuditTriplestoreConfig.class);
    static final String AUDIT_ENABLED = "audit.enabled";
    @Value(value="${audit.input.stream:broker:topic:fedora}")
    private String inputStream;
    @Value(value="${audit.event.baseUri:http://example.com/event}")
    private String eventBaseUri;
    @Value(value="${audit.triplestore.baseUrl:http://localhost:3030/fuseki/test/update}")
    private String triplestoreBaseUrl;
    @Value(value="${audit.triplestore.authUsername:}")
    private String triplestoreAuthUsername;
    @Value(value="${audit.triplestore.authPassword:}")
    private String tripleStoreAuthPassword;
    @Value(value="${audit.filter.containers:http://localhost:8080/fcrepo/rest/audit}")
    private String filterContainers;

    @Bean(name={"http"})
    public HttpComponent http() {
        return new HttpComponent();
    }

    @Bean(name={"https"})
    public HttpComponent https() {
        return new HttpComponent();
    }

    @Bean
    public RouteBuilder route() {
        return new EventRouter();
    }

    public String getTriplestoreBaseUrl() {
        return this.triplestoreBaseUrl;
    }

    public String getTriplestoreAuthPassword() {
        return this.tripleStoreAuthPassword;
    }

    public String getTriplestoreAuthUsername() {
        return this.triplestoreAuthUsername;
    }

    public String getFilterContainers() {
        return this.filterContainers;
    }

    public String getEventBaseUri() {
        return this.eventBaseUri;
    }

    public String getInputStream() {
        return this.inputStream;
    }

    static class AuditTriplestoreEnabled
    extends ConditionOnPropertyTrue {
        AuditTriplestoreEnabled() {
            super(FcrepoAuditTriplestoreConfig.AUDIT_ENABLED, false);
        }
    }
}

