/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.toolbox.app;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.fcrepo.camel.toolbox.app.AppVersionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import picocli.CommandLine;

@CommandLine.Command(name="fcrepo-camel-toolbox", mixinStandardHelpOptions=true, sortOptions=false, versionProvider=AppVersionProvider.class)
public class Driver
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Driver.class);
    @CommandLine.Option(names={"--config", "-c"}, required=false, order=1, description={"The path to the configuration file"})
    private Path configurationFilePath;

    @Override
    public Integer call() {
        if (this.configurationFilePath != null) {
            System.setProperty("fcrepo.camel.toolbox.config.file", this.configurationFilePath.toFile().getAbsolutePath());
        }
        AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext(new String[]{"org.fcrepo.camel"});
        appContext.registerShutdownHook();
        appContext.start();
        LOGGER.info("fcrepo-camel-toolbox started.");
        while (appContext.isRunning()) {
            Thread.onSpinWait();
        }
        return 0;
    }

    public static void main(String[] args) {
        Driver driver = new Driver();
        CommandLine cmd = new CommandLine((Object)driver);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new AppExceptionHandler(driver));
        cmd.execute(args);
    }

    private static class AppExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private final Driver driver;

        AppExceptionHandler(Driver driver) {
            this.driver = driver;
        }

        public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
            commandLine.getErr().println(ex.getMessage());
            ex.printStackTrace(commandLine.getErr());
            commandLine.usage(commandLine.getErr());
            return commandLine.getCommandSpec().exitCodeOnExecutionException();
        }
    }
}

