/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.GraphServiceFactory;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.MGraphServiceFactory;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.QueryableTcProvider;
import org.apache.clerezza.rdf.core.access.TcProvider;
import org.apache.clerezza.rdf.core.access.TcProviderMultiplexer;
import org.apache.clerezza.rdf.core.access.WeightedTcProvider;
import org.apache.clerezza.rdf.core.access.security.TcAccessController;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.WriteBlockedMGraph;
import org.apache.clerezza.rdf.core.impl.WriteBlockedTripleCollection;
import org.apache.clerezza.rdf.core.sparql.NoQueryEngineException;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.core.sparql.QueryEngine;
import org.apache.clerezza.rdf.core.sparql.ResultSet;
import org.apache.clerezza.rdf.core.sparql.SparqlPreParser;
import org.apache.clerezza.rdf.core.sparql.query.AskQuery;
import org.apache.clerezza.rdf.core.sparql.query.ConstructQuery;
import org.apache.clerezza.rdf.core.sparql.query.DescribeQuery;
import org.apache.clerezza.rdf.core.sparql.query.Query;
import org.apache.clerezza.rdf.core.sparql.query.SelectQuery;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={TcManager.class}, immediate=true)
public class TcManager
extends TcProviderMultiplexer {
    public static final String GENERAL_PURPOSE_TC = "general.purpose.tc";
    private static volatile TcManager instance;
    private TcAccessController tcAccessController = new TcAccessController(){

        @Override
        protected TcManager getTcManager() {
            return TcManager.this;
        }
    };
    private Map<UriRef, ServiceRegistration> serviceRegistrations = Collections.synchronizedMap(new HashMap());
    protected QueryEngine queryEngine;
    private ComponentContext componentContext;
    private Collection<UriRef> mGraphsToRegisterOnActivation = new HashSet<UriRef>();
    private Collection<UriRef> graphsToRegisterOnActivation = new HashSet<UriRef>();

    public TcManager() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TcManager getInstance() {
        if (instance != null) return instance;
        Class<TcManager> clazz = TcManager.class;
        synchronized (TcManager.class) {
            if (instance != null) return instance;
            instance = new TcManager();
            for (WeightedTcProvider weightedProvider : ServiceLoader.load(WeightedTcProvider.class)) {
                instance.bindWeightedTcProvider(weightedProvider);
            }
            Iterator<QueryEngine> queryEngines = ServiceLoader.load(QueryEngine.class).iterator();
            System.out.println("looking for QE");
            if (!queryEngines.hasNext()) return instance;
            TcManager.instance.queryEngine = queryEngines.next();
            System.out.println("QE: " + TcManager.instance.queryEngine.getClass());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        for (UriRef name : this.mGraphsToRegisterOnActivation) {
            this.registerTripleCollectionAsService(name, true);
        }
        for (UriRef name : this.graphsToRegisterOnActivation) {
            this.registerTripleCollectionAsService(name, false);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        for (ServiceRegistration registration : this.serviceRegistrations.values()) {
            registration.unregister();
        }
        this.serviceRegistrations.clear();
        this.componentContext = null;
    }

    @Override
    public Graph getGraph(UriRef name) throws NoSuchEntityException {
        this.tcAccessController.checkReadPermission(name);
        return super.getGraph(name);
    }

    @Override
    public LockableMGraph getMGraph(UriRef name) {
        try {
            this.tcAccessController.checkReadWritePermission(name);
        }
        catch (AccessControlException e) {
            this.tcAccessController.checkReadPermission(name);
            return new WriteBlockedMGraph(super.getMGraph(name));
        }
        return super.getMGraph(name);
    }

    @Override
    public TripleCollection getTriples(UriRef name) {
        try {
            this.tcAccessController.checkReadWritePermission(name);
        }
        catch (AccessControlException e) {
            this.tcAccessController.checkReadPermission(name);
            return new WriteBlockedTripleCollection(super.getTriples(name));
        }
        return super.getTriples(name);
    }

    @Override
    public LockableMGraph createMGraph(UriRef name) throws UnsupportedOperationException {
        this.tcAccessController.checkReadWritePermission(name);
        return super.createMGraph(name);
    }

    @Override
    public Graph createGraph(UriRef name, TripleCollection triples) {
        this.tcAccessController.checkReadWritePermission(name);
        return super.createGraph(name, triples);
    }

    @Override
    public void deleteTripleCollection(UriRef name) {
        this.tcAccessController.checkReadWritePermission(name);
        super.deleteTripleCollection(name);
    }

    @Override
    public Set<UriRef> getNames(Graph graph) {
        return super.getNames(graph);
    }

    @Override
    public Set<UriRef> listGraphs() {
        Set<UriRef> result = super.listGraphs();
        return this.excludeNonReadable(result);
    }

    @Override
    public Set<UriRef> listMGraphs() {
        Set<UriRef> result = super.listMGraphs();
        return this.excludeNonReadable(result);
    }

    @Override
    public Set<UriRef> listTripleCollections() {
        Set<UriRef> result = super.listTripleCollections();
        return this.excludeNonReadable(result);
    }

    private Set<UriRef> excludeNonReadable(Set<UriRef> tcNames) {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return tcNames;
        }
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (UriRef name : tcNames) {
            try {
                this.tcAccessController.checkReadPermission(name);
            }
            catch (AccessControlException e) {
                continue;
            }
            result.add(name);
        }
        return result;
    }

    public Object executeSparqlQuery(String query, TripleCollection defaultGraph) throws ParseException {
        TcProvider singleTargetTcProvider = null;
        SparqlPreParser sparqlPreParser = new SparqlPreParser(this);
        UriRef defaultGraphName = new UriRef("urn:x-temp:/kjsfadfhfasdffds");
        Set<UriRef> referencedGraphs = sparqlPreParser.getReferredGraphs(query, defaultGraphName);
        if (referencedGraphs != null && !referencedGraphs.contains(defaultGraphName)) {
            singleTargetTcProvider = this.getSingleTargetTcProvider(referencedGraphs);
        }
        if (singleTargetTcProvider != null && singleTargetTcProvider instanceof QueryableTcProvider) {
            return ((QueryableTcProvider)singleTargetTcProvider).executeSparqlQuery(query, null);
        }
        QueryEngine queryEngine = this.queryEngine;
        if (queryEngine != null) {
            return queryEngine.execute(this, defaultGraph, query);
        }
        throw new NoQueryEngineException();
    }

    public Object executeSparqlQuery(String query, boolean forceFastlane) throws ParseException {
        TcProvider singleTargetTcProvider = null;
        if (forceFastlane) {
            singleTargetTcProvider = this.getSingleTargetTcProvider(Collections.EMPTY_SET);
        } else {
            SparqlPreParser sparqlPreParser = new SparqlPreParser(this);
            UriRef defaultGraphName = new UriRef("urn:x-temp:/kjsfadfhfasdffds");
            Set<UriRef> referencedGraphs = sparqlPreParser.getReferredGraphs(query, defaultGraphName);
            if (referencedGraphs != null && !referencedGraphs.contains(defaultGraphName)) {
                singleTargetTcProvider = this.getSingleTargetTcProvider(referencedGraphs);
            }
        }
        if (singleTargetTcProvider != null && singleTargetTcProvider instanceof QueryableTcProvider) {
            return ((QueryableTcProvider)singleTargetTcProvider).executeSparqlQuery(query, null);
        }
        QueryEngine queryEngine = this.queryEngine;
        if (queryEngine != null) {
            return queryEngine.execute(this, (TripleCollection)new SimpleMGraph(), query);
        }
        throw new NoQueryEngineException();
    }

    public Object executeSparqlQuery(String query, UriRef defaultGraphName) throws ParseException {
        return this.executeSparqlQuery(query, defaultGraphName, false);
    }

    public Object executeSparqlQuery(String query, UriRef defaultGraphName, boolean forceFastlane) throws ParseException {
        TcProvider singleTargetTcProvider = null;
        if (forceFastlane) {
            singleTargetTcProvider = this.getSingleTargetTcProvider(Collections.singleton(defaultGraphName));
        } else {
            SparqlPreParser sparqlPreParser = new SparqlPreParser(this);
            Set<UriRef> referencedGraphs = sparqlPreParser.getReferredGraphs(query, defaultGraphName);
            if (referencedGraphs != null) {
                singleTargetTcProvider = this.getSingleTargetTcProvider(referencedGraphs);
            }
        }
        if (singleTargetTcProvider != null && singleTargetTcProvider instanceof QueryableTcProvider) {
            return ((QueryableTcProvider)singleTargetTcProvider).executeSparqlQuery(query, defaultGraphName);
        }
        QueryEngine queryEngine = this.queryEngine;
        if (queryEngine != null) {
            return queryEngine.execute(this, this.getTriples(defaultGraphName), query);
        }
        throw new NoQueryEngineException();
    }

    @Deprecated
    public Object executeSparqlQuery(Query query, TripleCollection defaultGraph) {
        QueryEngine queryEngine = this.queryEngine;
        if (queryEngine != null) {
            return queryEngine.execute(this, defaultGraph, query);
        }
        throw new NoQueryEngineException();
    }

    @Deprecated
    public ResultSet executeSparqlQuery(SelectQuery query, TripleCollection defaultGraph) {
        return (ResultSet)this.executeSparqlQuery((Query)query, defaultGraph);
    }

    @Deprecated
    public boolean executeSparqlQuery(AskQuery query, TripleCollection defaultGraph) {
        return (Boolean)this.executeSparqlQuery((Query)query, defaultGraph);
    }

    @Deprecated
    public Graph executeSparqlQuery(DescribeQuery query, TripleCollection defaultGraph) {
        return (Graph)this.executeSparqlQuery((Query)query, defaultGraph);
    }

    @Deprecated
    public Graph executeSparqlQuery(ConstructQuery query, TripleCollection defaultGraph) {
        return (Graph)this.executeSparqlQuery((Query)query, defaultGraph);
    }

    public TcAccessController getTcAccessController() {
        return this.tcAccessController;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void bindWeightedTcProvider(WeightedTcProvider provider) {
        this.addWeightedTcProvider(provider);
    }

    protected void unbindWeightedTcProvider(WeightedTcProvider provider) {
        this.removeWeightedTcProvider(provider);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE, target="(general.purpose.tc=true)")
    protected void bindGpWeightedTcProvider(WeightedTcProvider provider) {
        this.addWeightedTcProvider(provider);
    }

    protected void unbindGpWeightedTcProvider(WeightedTcProvider provider) {
        this.removeWeightedTcProvider(provider);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void bindQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    protected void unbindQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = null;
    }

    @Override
    protected void mGraphAppears(UriRef name) {
        if (this.componentContext == null) {
            this.mGraphsToRegisterOnActivation.add(name);
        } else {
            this.registerTripleCollectionAsService(name, true);
        }
    }

    @Override
    protected void graphAppears(UriRef name) {
        if (this.componentContext == null) {
            this.graphsToRegisterOnActivation.add(name);
        } else {
            this.registerTripleCollectionAsService(name, false);
        }
    }

    private void registerTripleCollectionAsService(UriRef name, boolean isMGraph) {
        Object service;
        String[] interfaceNames;
        Properties props = new Properties();
        ((Dictionary)props).put("name", name.getUnicodeString());
        if (isMGraph) {
            interfaceNames = new String[]{MGraph.class.getName(), LockableMGraph.class.getName()};
            service = new MGraphServiceFactory(this, name, this.tcAccessController);
        } else {
            interfaceNames = new String[]{Graph.class.getName()};
            service = new GraphServiceFactory(this, name, this.tcAccessController);
        }
        int bundleState = this.componentContext.getBundleContext().getBundle().getState();
        if (bundleState == 32 || bundleState == 8) {
            ServiceRegistration serviceReg = this.componentContext.getBundleContext().registerService(interfaceNames, service, (Dictionary)props);
            this.serviceRegistrations.put(name, serviceReg);
        }
    }

    @Override
    protected void tcDisappears(UriRef name) {
        this.mGraphsToRegisterOnActivation.remove(name);
        this.graphsToRegisterOnActivation.remove(name);
        ServiceRegistration reg = this.serviceRegistrations.get(name);
        if (reg != null) {
            reg.unregister();
            this.serviceRegistrations.remove(name);
        }
    }

    private TcProvider getSingleTargetTcProvider(Set<UriRef> referencedGraphs) {
        WeightedTcProvider singleTargetTcProvider = null;
        for (WeightedTcProvider provider : this.providerList) {
            Set<UriRef> providerTripleCollections = provider.listTripleCollections();
            if (providerTripleCollections.containsAll(referencedGraphs)) {
                singleTargetTcProvider = provider;
                break;
            }
            for (UriRef graphName : referencedGraphs) {
                if (providerTripleCollections.contains(graphName)) break;
            }
        }
        return singleTargetTcProvider;
    }
}

