/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import java.io.Serializable;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.PlainLiteral;

public class PlainLiteralImpl
implements PlainLiteral,
Serializable {
    private String lexicalForm;
    private Language language = null;

    public PlainLiteralImpl(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The literal string cannot be null");
        }
        this.lexicalForm = value;
    }

    public PlainLiteralImpl(String value, Language language) {
        if (value == null) {
            throw new IllegalArgumentException("The literal string cannot be null");
        }
        this.lexicalForm = value;
        this.language = language;
    }

    @Override
    public String getLexicalForm() {
        return this.lexicalForm;
    }

    @Override
    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof PlainLiteral)) {
            return false;
        }
        PlainLiteral other = (PlainLiteral)otherObj;
        if (!this.lexicalForm.equals(other.getLexicalForm())) {
            return false;
        }
        if (this.language != null) {
            return this.language.equals(other.getLanguage());
        }
        return other.getLanguage() == null;
    }

    @Override
    public int hashCode() {
        int hash = this.lexicalForm.hashCode();
        if (this.language != null) {
            hash += this.language.hashCode();
        }
        return hash;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('\"').append(this.lexicalForm).append('\"');
        if (this.language != null) {
            result.append("@").append(this.language.toString());
        }
        return result.toString();
    }
}

