/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import java.io.Serializable;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;

public class TypedLiteralImpl
implements TypedLiteral,
Serializable {
    private String lexicalForm;
    private UriRef dataType;
    private int hashCode;

    public TypedLiteralImpl(String lexicalForm, UriRef dataType) {
        this.lexicalForm = lexicalForm;
        this.dataType = dataType;
        this.hashCode = lexicalForm.hashCode() + dataType.hashCode();
    }

    @Override
    public UriRef getDataType() {
        return this.dataType;
    }

    @Override
    public String getLexicalForm() {
        return this.lexicalForm;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TypedLiteral) {
            TypedLiteral other = (TypedLiteral)obj;
            boolean res = this.getDataType().equals(other.getDataType()) && this.getLexicalForm().equals(other.getLexicalForm());
            return res;
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('\"');
        result.append(this.getLexicalForm());
        result.append('\"');
        result.append("^^");
        result.append(this.getDataType());
        return result.toString();
    }
}

