/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.serializedform;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.serializedform.ParsingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedFormatException;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedParsingFormatException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Parser.class})
public class Parser {
    private ConfigurationAdmin configurationAdmin;
    private List<ParsingProvider> providerList = new ArrayList<ParsingProvider>();
    private volatile Map<String, ParsingProvider> providerMap = new HashMap<String, ParsingProvider>();
    private static volatile Parser instance;
    private boolean active;
    private static final Logger log;

    public Parser() {
        log.info("constructing Parser");
        instance = this;
    }

    Parser(Object dummy) {
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Parser getInstance() {
        if (instance != null) return instance;
        Class<Parser> clazz = Parser.class;
        synchronized (Parser.class) {
            if (instance != null) return instance;
            new Parser();
            for (ParsingProvider parsingProvider : ServiceLoader.load(ParsingProvider.class)) {
                instance.bindParsingProvider(parsingProvider);
            }
            Parser.instance.active = true;
            instance.refreshProviderMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.active = true;
        this.refreshProviderMap();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.active = false;
    }

    @Modified
    void modified(ComponentContext ctx) {
        log.debug("modified");
    }

    public Graph parse(InputStream serializedGraph, String formatIdentifier) throws UnsupportedFormatException {
        return this.parse(serializedGraph, formatIdentifier, null);
    }

    public void parse(MGraph target, InputStream serializedGraph, String formatIdentifier) throws UnsupportedFormatException {
        this.parse(target, serializedGraph, formatIdentifier, null);
    }

    public Graph parse(InputStream serializedGraph, String formatIdentifier, UriRef baseUri) throws UnsupportedFormatException {
        SimpleMGraph mGraph = new SimpleMGraph();
        this.parse(mGraph, serializedGraph, formatIdentifier, baseUri);
        return mGraph.getGraph();
    }

    public void parse(MGraph target, InputStream serializedGraph, String formatIdentifier, UriRef baseUri) throws UnsupportedFormatException {
        int semicolonPos = formatIdentifier.indexOf(59);
        String deParameterizedIdentifier = semicolonPos > -1 ? formatIdentifier.substring(0, semicolonPos) : formatIdentifier;
        ParsingProvider provider = this.providerMap.get(deParameterizedIdentifier);
        if (provider == null) {
            throw new UnsupportedParsingFormatException(formatIdentifier);
        }
        provider.parse(target, serializedGraph, formatIdentifier, baseUri);
    }

    public Set<String> getSupportedFormats() {
        return Collections.unmodifiableSet(this.providerMap.keySet());
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindParsingProvider(ParsingProvider provider) {
        this.providerList.add(provider);
        this.refreshProviderMap();
    }

    public void unbindParsingProvider(ParsingProvider provider) {
        this.providerList.remove(provider);
        this.refreshProviderMap();
    }

    private void refreshProviderMap() {
        if (this.active) {
            try {
                HashMap<String, ParsingProvider> newProviderMap = new HashMap<String, ParsingProvider>();
                for (ParsingProvider provider : this.providerList) {
                    String[] formatIdentifiers;
                    for (String formatIdentifier : formatIdentifiers = this.getFormatIdentifiers(provider)) {
                        newProviderMap.put(formatIdentifier, provider);
                    }
                }
                this.providerMap = newProviderMap;
                if (this.configurationAdmin != null) {
                    Hashtable<String, String[]> newConfig = this.configurationAdmin.getConfiguration(this.getClass().getName()).getProperties();
                    if (newConfig == null) {
                        newConfig = new Hashtable<String, String[]>();
                    }
                    Set<String> supportedFormats = this.getSupportedFormats();
                    String[] supportedFromatsArray = supportedFormats.toArray(new String[supportedFormats.size()]);
                    ((Dictionary)newConfig).put("supportedFormat", supportedFromatsArray);
                    this.configurationAdmin.getConfiguration(this.getClass().getName()).update(newConfig);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private String[] getFormatIdentifiers(ParsingProvider parsingProvider) {
        Class<?> clazz = parsingProvider.getClass();
        SupportedFormat supportedFormatAnnotation = clazz.getAnnotation(SupportedFormat.class);
        String[] formatIdentifiers = supportedFormatAnnotation.value();
        return formatIdentifiers;
    }

    @Reference
    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = null;
    }

    static {
        log = LoggerFactory.getLogger(Parser.class);
    }
}

