/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.serializedform;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.serializedform.SerializingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedFormatException;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedSerializationFormatException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Serializer.class})
public class Serializer {
    private ConfigurationAdmin configurationAdmin;
    private List<SerializingProvider> providerList = new ArrayList<SerializingProvider>();
    private volatile Map<String, SerializingProvider> providerMap = new HashMap<String, SerializingProvider>();
    private static volatile Serializer instance;
    private static final Logger log;
    private boolean active;

    public Serializer() {
        instance = this;
    }

    Serializer(Object dummy) {
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Serializer getInstance() {
        if (instance != null) return instance;
        Class<Serializer> clazz = Serializer.class;
        synchronized (Serializer.class) {
            if (instance != null) return instance;
            new Serializer();
            for (SerializingProvider SerializingProvider2 : ServiceLoader.load(SerializingProvider.class)) {
                instance.bindSerializingProvider(SerializingProvider2);
            }
            Serializer.instance.active = true;
            instance.refreshProviderMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.active = true;
        this.refreshProviderMap();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.active = false;
    }

    @Modified
    void modified(ComponentContext ctx) {
        log.debug("modified");
    }

    public void serialize(OutputStream serializedGraph, TripleCollection tc, String formatIdentifier) throws UnsupportedFormatException {
        int semicolonPos = formatIdentifier.indexOf(59);
        String deParameterizedIdentifier = semicolonPos > -1 ? formatIdentifier.substring(0, semicolonPos) : formatIdentifier;
        SerializingProvider provider = this.providerMap.get(deParameterizedIdentifier);
        if (provider == null) {
            throw new UnsupportedSerializationFormatException(formatIdentifier);
        }
        provider.serialize(serializedGraph, tc, formatIdentifier);
    }

    public Set<String> getSupportedFormats() {
        return Collections.unmodifiableSet(this.providerMap.keySet());
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    public void bindSerializingProvider(SerializingProvider provider) {
        this.providerList.add(provider);
        this.refreshProviderMap();
    }

    public void unbindSerializingProvider(SerializingProvider provider) {
        this.providerList.remove(provider);
        this.refreshProviderMap();
    }

    private void refreshProviderMap() {
        if (this.active) {
            HashMap<String, SerializingProvider> newProviderMap = new HashMap<String, SerializingProvider>();
            Collections.sort(this.providerList, new Comparator<SerializingProvider>(){

                @Override
                public int compare(SerializingProvider s1, SerializingProvider s2) {
                    return Serializer.this.getFormatIdentifiers(s2).length - Serializer.this.getFormatIdentifiers(s1).length;
                }
            });
            for (SerializingProvider provider : this.providerList) {
                String[] formatIdentifiers;
                for (String formatIdentifier : formatIdentifiers = this.getFormatIdentifiers(provider)) {
                    newProviderMap.put(formatIdentifier, provider);
                }
            }
            this.providerMap = newProviderMap;
            if (this.configurationAdmin != null) {
                try {
                    Hashtable<String, String[]> newConfig = this.configurationAdmin.getConfiguration(this.getClass().getName()).getProperties();
                    if (newConfig == null) {
                        newConfig = new Hashtable<String, String[]>();
                    }
                    Set<String> supportedFormats = this.getSupportedFormats();
                    String[] supportedFromatsArray = supportedFormats.toArray(new String[supportedFormats.size()]);
                    ((Dictionary)newConfig).put("supportedFormat", supportedFromatsArray);
                    this.configurationAdmin.getConfiguration(this.getClass().getName()).update(newConfig);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private String[] getFormatIdentifiers(SerializingProvider SerializingProvider2) {
        Class<?> clazz = SerializingProvider2.getClass();
        SupportedFormat supportedFormatAnnotation = clazz.getAnnotation(SupportedFormat.class);
        String[] formatIdentifiers = supportedFormatAnnotation.value();
        return formatIdentifiers;
    }

    @Reference
    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = null;
    }

    static {
        log = LoggerFactory.getLogger(Serializer.class);
    }
}

