/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.Literal;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;
import org.apache.clerezza.rdf.core.sparql.JavaCCGeneratedSparqlPreParserConstants;
import org.apache.clerezza.rdf.core.sparql.JavaCCGeneratedSparqlPreParserTokenManager;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.core.sparql.SimpleCharStream;
import org.apache.clerezza.rdf.core.sparql.Token;
import org.apache.clerezza.rdf.core.sparql.query.BinaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.BinaryPropertyPathOperation;
import org.apache.clerezza.rdf.core.sparql.query.BuiltInCall;
import org.apache.clerezza.rdf.core.sparql.query.Expression;
import org.apache.clerezza.rdf.core.sparql.query.FunctionCall;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.InlineData;
import org.apache.clerezza.rdf.core.sparql.query.LiteralExpression;
import org.apache.clerezza.rdf.core.sparql.query.PatternExistenceCondition;
import org.apache.clerezza.rdf.core.sparql.query.PredicatePath;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathExpression;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathExpressionOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathPattern;
import org.apache.clerezza.rdf.core.sparql.query.PropertySet;
import org.apache.clerezza.rdf.core.sparql.query.Query;
import org.apache.clerezza.rdf.core.sparql.query.ResourceOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.RhsListBinaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.SelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.SparqlUnit;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.UnaryOperation;
import org.apache.clerezza.rdf.core.sparql.query.UnaryPropertyPathOperation;
import org.apache.clerezza.rdf.core.sparql.query.UriRefExpression;
import org.apache.clerezza.rdf.core.sparql.query.UriRefOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.Variable;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleAlternativeGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleAskQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleConstructQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleDataSet;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleDescribeQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleGraphGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleGroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleInlineData;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleOrderCondition;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimplePropertyPathPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleQueryWithSolutionModifier;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleSelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleServiceGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleSparqlUnit;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleTriplePattern;
import org.apache.clerezza.rdf.core.sparql.update.Update;
import org.apache.clerezza.rdf.core.sparql.update.UpdateOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.AddOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.ClearOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.ClearOrDropOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.CopyOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.CreateOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.DeleteDataOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.DeleteWhereOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.DropOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.InsertDataOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.LoadOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.ModifyOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.MoveOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.SimpleUpdate;
import org.apache.clerezza.rdf.core.sparql.update.impl.SimpleUpdateOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.UpdateOperationWithQuads;

class JavaCCGeneratedSparqlPreParser
implements JavaCCGeneratedSparqlPreParserConstants {
    private static final UriRef RDF_TYPE = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    private static final UriRef RDF_FIRST = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
    private static final UriRef RDF_REST = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
    private static final UriRef RDF_NIL = new UriRef("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    private static final Pattern pfxNamePattern = Pattern.compile("([^:]*):(.*)");
    private String base;
    private Map<String, String> prefixes;
    private Map<String, ResourceOrVariable> bNodes;
    private int count;
    public JavaCCGeneratedSparqlPreParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[154];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    void initialize() {
        this.base = null;
        this.prefixes = new HashMap<String, String>();
        this.bNodes = new HashMap<String, ResourceOrVariable>();
        this.count = 0;
    }

    SparqlUnit parse() throws ParseException {
        this.initialize();
        SparqlUnit sparqlUnit = this.SparqlUnit();
        return sparqlUnit;
    }

    Query parseQuery() throws ParseException {
        this.initialize();
        Query query = this.QueryUnit();
        return query;
    }

    Update parseUpdate() throws ParseException {
        this.initialize();
        Update update = this.UpdateUnit();
        return update;
    }

    private static String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static String unTripleQuote(String s) {
        return s.substring(3, s.length() - 3);
    }

    private Variable createVariable(String name) {
        name = name.substring(1);
        Variable v = new Variable(name);
        return v;
    }

    private void addPropertyPathPatterns(Set<PropertyPathPattern> propertyPathPatterns, ResourceOrVariable subject, PropertyPathExpressionOrVariable propertyPathExpression, Set<ResourceOrVariable> objects) {
        for (ResourceOrVariable object : objects) {
            propertyPathPatterns.add(new SimplePropertyPathPattern(subject, propertyPathExpression, object));
        }
    }

    private ResourceOrVariable addPropertyPathPatterns(Set<PropertyPathPattern> propertyPathPatterns, List<ResourceOrVariable> nodes) {
        ResourceOrVariable head = null;
        PropertyPathExpressionOrVariable rdfFirst = new PropertyPathExpressionOrVariable(new PredicatePath(RDF_FIRST));
        PropertyPathExpressionOrVariable rdfRest = new PropertyPathExpressionOrVariable(new PredicatePath(RDF_REST));
        UriRefOrVariable rdfNil = new UriRefOrVariable(RDF_NIL);
        ResourceOrVariable prevSubject = null;
        for (ResourceOrVariable node : nodes) {
            ResourceOrVariable currentSubject = this.getNewBNode();
            if (prevSubject != null) {
                propertyPathPatterns.add(new SimplePropertyPathPattern(prevSubject, rdfRest, currentSubject));
            } else {
                head = currentSubject;
            }
            propertyPathPatterns.add(new SimplePropertyPathPattern(currentSubject, rdfFirst, node));
            prevSubject = currentSubject;
        }
        if (prevSubject != null) {
            propertyPathPatterns.add(new SimplePropertyPathPattern(prevSubject, rdfRest, rdfNil));
        }
        return head;
    }

    private void addTriplePatterns(Set<TriplePattern> triplePatterns, ResourceOrVariable subject, UriRefOrVariable predicate, Set<ResourceOrVariable> objects) {
        for (ResourceOrVariable object : objects) {
            triplePatterns.add(new SimpleTriplePattern(subject, predicate, object));
        }
    }

    private ResourceOrVariable addTriplePatterns(Set<TriplePattern> triplePatterns, List<ResourceOrVariable> nodes) {
        ResourceOrVariable head = null;
        UriRefOrVariable rdfFirst = new UriRefOrVariable(RDF_FIRST);
        UriRefOrVariable rdfRest = new UriRefOrVariable(RDF_REST);
        UriRefOrVariable rdfNil = new UriRefOrVariable(RDF_NIL);
        ResourceOrVariable prevSubject = null;
        for (ResourceOrVariable node : nodes) {
            ResourceOrVariable currentSubject = this.getNewBNode();
            if (prevSubject != null) {
                triplePatterns.add(new SimpleTriplePattern(prevSubject, rdfRest, currentSubject));
            } else {
                head = currentSubject;
            }
            triplePatterns.add(new SimpleTriplePattern(currentSubject, rdfFirst, node));
            prevSubject = currentSubject;
        }
        if (prevSubject != null) {
            triplePatterns.add(new SimpleTriplePattern(prevSubject, rdfRest, rdfNil));
        }
        return head;
    }

    private ResourceOrVariable getNewBNode() {
        ResourceOrVariable bNode = new ResourceOrVariable(new BNode());
        this.bNodes.put("*" + this.count++, bNode);
        return bNode;
    }

    private ResourceOrVariable getBNode(String label) {
        ResourceOrVariable bNode = this.bNodes.get(label);
        if (bNode == null) {
            bNode = new ResourceOrVariable(new BNode());
            this.bNodes.put(label, bNode);
        }
        return bNode;
    }

    private UriRef createUriRef(String r) throws ParseException {
        Matcher m = pfxNamePattern.matcher(r);
        if (!m.matches()) {
            return JavaCCGeneratedSparqlPreParser.isRelative(r) ? new UriRef(this.base + r) : new UriRef(r);
        }
        String ns = this.prefixes.get(m.group(1));
        return ns == null ? new UriRef(r) : new UriRef(ns + m.group(2));
    }

    private static boolean isRelative(String u) {
        int colon = u.indexOf(58);
        if (colon < 0) {
            return true;
        }
        for (int c = 0; c < colon; ++c) {
            if (Character.isLetterOrDigit(u.charAt(c))) continue;
            return true;
        }
        return false;
    }

    private final SparqlUnit SparqlUnit() throws ParseException {
        this.Prologue();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 15: 
            case 19: 
            case 23: {
                Query query = this.QueryUnit();
                return new SimpleSparqlUnit(query);
            }
        }
        this.jj_la1[0] = this.jj_gen;
        Update update = this.UpdateUnit();
        return new SimpleSparqlUnit(update);
    }

    private final Query QueryUnit() throws ParseException {
        Query query = this.Query();
        return query;
    }

    private final Query Query() throws ParseException {
        Query query;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                query = this.SelectQuery();
                break;
            }
            case 15: {
                query = this.ConstructQuery();
                break;
            }
            case 19: {
                query = this.DescribeQuery();
                break;
            }
            case 23: {
                query = this.AskQuery();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    private final Update UpdateUnit() throws ParseException {
        SimpleUpdate update = new SimpleUpdate();
        this.Update(update);
        return update;
    }

    private final void Prologue() throws ParseException {
        block8: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 14: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.BaseDecl();
                        continue block7;
                    }
                    case 14: {
                        this.PrefixDecl();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    private final void BaseDecl() throws ParseException {
        this.jj_consume_token(9);
        Token iriRef = this.jj_consume_token(96);
        this.base = JavaCCGeneratedSparqlPreParser.unquote(iriRef.image);
    }

    private final void PrefixDecl() throws ParseException {
        this.jj_consume_token(14);
        Token ns = this.jj_consume_token(97);
        Token iriRef = this.jj_consume_token(96);
        String pfx = ns.image;
        this.prefixes.put(pfx.substring(0, pfx.length() - 1), JavaCCGeneratedSparqlPreParser.unquote(iriRef.image));
    }

    private final Query SelectQuery() throws ParseException {
        Query query = this.SelectClause();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause(query);
        }
        this.WhereClause(query);
        this.SolutionModifier(query);
        return query;
    }

    private final Query SubSelect() throws ParseException {
        Query query = this.SelectClause();
        this.WhereClause(query);
        this.SolutionModifier(query);
        this.ValuesClause(query);
        return query;
    }

    private final Query SelectClause() throws ParseException {
        this.jj_consume_token(8);
        SimpleSelectQuery query = new SimpleSelectQuery();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 26: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        query.setDistinct();
                        break block0;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        query.setReduced();
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 100: 
            case 101: {
                block18: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 100: 
                        case 101: {
                            Variable v = this.Var();
                            query.addSelection(v);
                            break;
                        }
                        case 67: {
                            this.jj_consume_token(67);
                            Expression e = this.Expression();
                            this.jj_consume_token(33);
                            Variable v = this.Var();
                            v.setBoundExpression(e);
                            query.addSelection(v);
                            this.jj_consume_token(68);
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 67: 
                        case 100: 
                        case 101: {
                            continue block18;
                        }
                    }
                    break;
                }
                this.jj_la1[8] = this.jj_gen;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                query.setSelectAll();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return query;
    }

    private final Query ConstructQuery() throws ParseException {
        SimpleConstructQuery query;
        Set<TriplePattern> triplePatterns = null;
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                triplePatterns = this.ConstructTemplate();
                query = new SimpleConstructQuery(triplePatterns);
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.DatasetClause(query);
                }
                this.WhereClause(query);
                break;
            }
            case 12: 
            case 21: {
                query = new SimpleConstructQuery(triplePatterns);
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.DatasetClause(query);
                }
                this.jj_consume_token(21);
                this.jj_consume_token(70);
                SimpleGroupGraphPattern queryPattern = new SimpleGroupGraphPattern();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: 
                    case 30: 
                    case 67: 
                    case 84: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 124: {
                        triplePatterns = this.TriplesTemplate();
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                queryPattern.addTriplePatterns(triplePatterns);
                this.jj_consume_token(71);
                ((SimpleQuery)query).setQueryPattern(queryPattern);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.SolutionModifier(query);
        return query;
    }

    private final Query DescribeQuery() throws ParseException {
        this.jj_consume_token(19);
        SimpleDescribeQuery query = new SimpleDescribeQuery();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                block13: while (true) {
                    UriRefOrVariable node = this.VarOrIri();
                    query.addResourceToDescribe(node);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 96: 
                        case 97: 
                        case 98: 
                        case 100: 
                        case 101: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[14] = this.jj_gen;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                query.setDescribeAll();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block14;
                }
            }
            this.DatasetClause(query);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 70: {
                this.WhereClause(query);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        this.SolutionModifier(query);
        return query;
    }

    private final Query AskQuery() throws ParseException {
        this.jj_consume_token(23);
        SimpleAskQuery query = new SimpleAskQuery();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause(query);
        }
        this.WhereClause(query);
        this.SolutionModifier(query);
        return query;
    }

    private final void DatasetClause(Query query) throws ParseException {
        this.jj_consume_token(12);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: {
                this.DefaultGraphClause(query);
                break;
            }
            case 17: {
                this.NamedGraphClause(query);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void DefaultGraphClause(Query query) throws ParseException {
        UriRef defaultGraph = this.SourceSelector();
        ((SimpleQuery)query).addDefaultGraph(defaultGraph);
    }

    private final void NamedGraphClause(Query query) throws ParseException {
        this.jj_consume_token(17);
        UriRef namedGraph = this.SourceSelector();
        ((SimpleQuery)query).addNamedGraph(namedGraph);
    }

    private final UriRef SourceSelector() throws ParseException {
        UriRef graph = this.Iri();
        return graph;
    }

    private final void WhereClause(Query query) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        GroupGraphPattern queryPattern = this.GroupGraphPattern();
        ((SimpleQuery)query).setQueryPattern(queryPattern);
    }

    private final void SolutionModifier(Query query) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                this.GroupClause(query);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                this.HavingClause(query);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.OrderClause(query);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 20: {
                this.LimitOffsetClauses(query);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
    }

    private final void GroupClause(Query query) throws ParseException {
        this.jj_consume_token(37);
        this.jj_consume_token(11);
        block3: while (true) {
            this.GroupCondition(query);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 103: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[25] = this.jj_gen;
    }

    private final void GroupCondition(Query query) throws ParseException {
        Expression e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 28: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 103: {
                e = this.BuiltInCall();
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                e = this.FunctionCall();
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                e = this.Expression();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        Variable v = this.Var();
                        v.setBoundExpression(e);
                        e = v;
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                    }
                }
                this.jj_consume_token(68);
                break;
            }
            case 100: 
            case 101: {
                e = this.Var();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ((SimpleQueryWithSolutionModifier)query).addGroupCondition(e);
    }

    private final void HavingClause(Query query) throws ParseException {
        this.jj_consume_token(38);
        block3: while (true) {
            this.HavingCondition(query);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 96: 
                case 97: 
                case 98: 
                case 103: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[28] = this.jj_gen;
    }

    private final void HavingCondition(Query query) throws ParseException {
        Expression c = this.Constraint();
        ((SimpleQueryWithSolutionModifier)query).addHavingCondition(c);
    }

    private final void OrderClause(Query query) throws ParseException {
        this.jj_consume_token(10);
        this.jj_consume_token(11);
        block3: while (true) {
            this.OrderCondition(query);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 72: 
                case 73: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 103: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[29] = this.jj_gen;
    }

    private final void OrderCondition(Query query) throws ParseException {
        Expression e;
        boolean asc = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: 
            case 73: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.jj_consume_token(72);
                        break;
                    }
                    case 73: {
                        this.jj_consume_token(73);
                        asc = false;
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                e = this.BrackettedExpression();
                break;
            }
            case 27: 
            case 28: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 103: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 28: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 103: {
                        e = this.Constraint();
                        break block0;
                    }
                    case 100: 
                    case 101: {
                        e = this.Var();
                        break block0;
                    }
                }
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ((SimpleQueryWithSolutionModifier)query).addOrderCondition(new SimpleOrderCondition(e, asc));
    }

    private final void LimitOffsetClauses(Query query) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.LimitClause(query);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.OffsetClause(query);
                        break block0;
                    }
                }
                this.jj_la1[33] = this.jj_gen;
                break;
            }
            case 20: {
                this.OffsetClause(query);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.LimitClause(query);
                        break block0;
                    }
                }
                this.jj_la1[34] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void LimitClause(Query query) throws ParseException {
        this.jj_consume_token(16);
        Token t = this.jj_consume_token(107);
        ((SimpleQueryWithSolutionModifier)query).setLimit(Integer.parseInt(t.image));
    }

    private final void OffsetClause(Query query) throws ParseException {
        this.jj_consume_token(20);
        Token t = this.jj_consume_token(107);
        ((SimpleQueryWithSolutionModifier)query).setOffset(Integer.parseInt(t.image));
    }

    private final void ValuesClause(Query query) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                InlineData data = this.DataBlock();
                ((SimpleQuery)query).setInlineData(data);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
    }

    private final void Update(Update update) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: {
                this.Update1(update);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        this.jj_consume_token(74);
                        this.Prologue();
                        this.Update(update);
                        break block0;
                    }
                }
                this.jj_la1[37] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
    }

    private final void Update1(Update update) throws ParseException {
        UpdateOperation updateOperation = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                updateOperation = this.Load();
                break;
            }
            case 42: {
                updateOperation = this.Clear();
                break;
            }
            case 43: {
                updateOperation = this.Drop();
                break;
            }
            case 45: {
                updateOperation = this.Add();
                break;
            }
            case 47: {
                updateOperation = this.Move();
                break;
            }
            case 48: {
                updateOperation = this.Copy();
                break;
            }
            case 44: {
                updateOperation = this.Create();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                if (this.jj_2_1(2)) {
                    updateOperation = this.InsertData();
                    break;
                }
                if (this.jj_2_2(2)) {
                    updateOperation = this.DeleteData();
                    break;
                }
                if (this.jj_2_3(2)) {
                    updateOperation = this.DeleteWhere();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: 
                    case 50: 
                    case 52: {
                        updateOperation = this.Modify();
                        break block0;
                    }
                }
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (updateOperation != null) {
            update.addOperation(updateOperation);
        }
    }

    private final UpdateOperation Load() throws ParseException {
        this.jj_consume_token(39);
        LoadOperation operation = new LoadOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                operation.setSilent(true);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        UriRef uriRef = this.Iri();
        operation.setSource(uriRef);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                uriRef = this.GraphRef();
                operation.setDestinationGraph(uriRef);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        return operation;
    }

    private final UpdateOperation Clear() throws ParseException {
        this.jj_consume_token(42);
        ClearOperation operation = new ClearOperation();
        this.ProcessParametersOfClearOrDropOperation(operation);
        return operation;
    }

    private final void ProcessParametersOfClearOrDropOperation(ClearOrDropOperation operation) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                operation.setSilent(true);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        GraphRefAllSpec graphRefAllSpec = this.GraphRefAll();
        UpdateOperation.GraphSpec graphSpec = graphRefAllSpec.getGraphSpec();
        operation.setDestinationGraphSpec(graphSpec);
        if (graphSpec == UpdateOperation.GraphSpec.GRAPH) {
            operation.setDestinationGraph(graphRefAllSpec.getGraph());
        }
    }

    private final UpdateOperation Drop() throws ParseException {
        this.jj_consume_token(43);
        DropOperation operation = new DropOperation();
        this.ProcessParametersOfClearOrDropOperation(operation);
        return operation;
    }

    private final UpdateOperation Create() throws ParseException {
        this.jj_consume_token(44);
        CreateOperation operation = new CreateOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                operation.setSilent(true);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        UriRef uriRef = this.GraphRef();
        operation.setDestinationGraph(uriRef);
        return operation;
    }

    private final UpdateOperation Add() throws ParseException {
        this.jj_consume_token(45);
        AddOperation operation = new AddOperation();
        this.ProcessParametersOfAddMoveOrCopyOperation(operation);
        return operation;
    }

    private final void ProcessParametersOfAddMoveOrCopyOperation(SimpleUpdateOperation operation) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                operation.setSilent(true);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        GraphRefAllSpec graphRefAllSpec = this.GraphOrDefault();
        UpdateOperation.GraphSpec graphSpec = graphRefAllSpec.getGraphSpec();
        if (graphSpec == UpdateOperation.GraphSpec.GRAPH) {
            operation.setInputGraph(graphRefAllSpec.getGraph());
        } else {
            operation.setInputGraphSpec(graphSpec);
        }
        this.jj_consume_token(46);
        graphRefAllSpec = this.GraphOrDefault();
        graphSpec = graphRefAllSpec.getGraphSpec();
        if (graphSpec == UpdateOperation.GraphSpec.GRAPH) {
            operation.setDestinationGraph(graphRefAllSpec.getGraph());
        } else {
            operation.setDestinationGraphSpec(graphSpec);
        }
    }

    private final UpdateOperation Move() throws ParseException {
        this.jj_consume_token(47);
        MoveOperation operation = new MoveOperation();
        this.ProcessParametersOfAddMoveOrCopyOperation(operation);
        return operation;
    }

    private final UpdateOperation Copy() throws ParseException {
        this.jj_consume_token(48);
        CopyOperation operation = new CopyOperation();
        this.ProcessParametersOfAddMoveOrCopyOperation(operation);
        return operation;
    }

    private final UpdateOperation InsertData() throws ParseException {
        this.jj_consume_token(49);
        this.jj_consume_token(51);
        InsertDataOperation operation = new InsertDataOperation();
        this.QuadData(operation);
        return operation;
    }

    private final UpdateOperation DeleteData() throws ParseException {
        this.jj_consume_token(50);
        this.jj_consume_token(51);
        DeleteDataOperation operation = new DeleteDataOperation();
        this.QuadData(operation);
        return operation;
    }

    private final UpdateOperation DeleteWhere() throws ParseException {
        this.jj_consume_token(50);
        this.jj_consume_token(21);
        DeleteWhereOperation operation = new DeleteWhereOperation();
        this.QuadPattern(operation);
        return operation;
    }

    private final UpdateOperation Modify() throws ParseException {
        UriRef fallbackGraph = null;
        UpdateOperationWithQuads deleteOperation = null;
        UpdateOperationWithQuads insertOperation = null;
        SimpleDataSet dataSet = new SimpleDataSet();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                fallbackGraph = this.Iri();
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                deleteOperation = this.DeleteClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        insertOperation = this.InsertClause();
                        break block3;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                break;
            }
            case 49: {
                insertOperation = this.InsertClause();
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ModifyOperation operation = new ModifyOperation();
        if (fallbackGraph != null) {
            operation.setFallbackGraph(fallbackGraph);
        }
        if (deleteOperation != null) {
            operation.setDeleteOperation(deleteOperation);
        }
        if (insertOperation != null) {
            operation.setInsertOperation(insertOperation);
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 53: {
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    break block13;
                }
            }
            this.UsingClause(dataSet);
        }
        operation.setDataSet(dataSet);
        this.jj_consume_token(21);
        GroupGraphPattern queryPattern = this.GroupGraphPattern();
        operation.setQueryPattern(queryPattern);
        return operation;
    }

    private final UpdateOperationWithQuads DeleteClause() throws ParseException {
        this.jj_consume_token(50);
        UpdateOperationWithQuads operation = new UpdateOperationWithQuads();
        this.QuadPattern(operation);
        return operation;
    }

    private final UpdateOperationWithQuads InsertClause() throws ParseException {
        this.jj_consume_token(49);
        UpdateOperationWithQuads operation = new UpdateOperationWithQuads();
        this.QuadPattern(operation);
        return operation;
    }

    private final void UsingClause(SimpleDataSet dataSet) throws ParseException {
        this.jj_consume_token(53);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: {
                UriRef graph = this.Iri();
                dataSet.addDefaultGraph(graph);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                UriRef graph = this.Iri();
                dataSet.addNamedGraph(graph);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final GraphRefAllSpec GraphOrDefault() throws ParseException {
        GraphRefAllSpec graphRefAllSpec = new GraphRefAllSpec();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                this.jj_consume_token(54);
                graphRefAllSpec.setGraphSpec(UpdateOperation.GraphSpec.DEFAULT);
                break;
            }
            case 13: 
            case 96: 
            case 97: 
            case 98: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                UriRef uriRef = this.Iri();
                graphRefAllSpec.setGraph(uriRef);
                graphRefAllSpec.setGraphSpec(UpdateOperation.GraphSpec.GRAPH);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return graphRefAllSpec;
    }

    private final UriRef GraphRef() throws ParseException {
        this.jj_consume_token(13);
        UriRef uriRef = this.Iri();
        return uriRef;
    }

    private final GraphRefAllSpec GraphRefAll() throws ParseException {
        GraphRefAllSpec graphRefAllSpec = new GraphRefAllSpec();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                UriRef uriRef = this.GraphRef();
                graphRefAllSpec.setGraph(uriRef);
                graphRefAllSpec.setGraphSpec(UpdateOperation.GraphSpec.GRAPH);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                graphRefAllSpec.setGraphSpec(UpdateOperation.GraphSpec.DEFAULT);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                graphRefAllSpec.setGraphSpec(UpdateOperation.GraphSpec.NAMED);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                graphRefAllSpec.setGraphSpec(UpdateOperation.GraphSpec.ALL);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return graphRefAllSpec;
    }

    private final void QuadPattern(UpdateOperationWithQuads operation) throws ParseException {
        this.jj_consume_token(70);
        this.Quads(operation);
        this.jj_consume_token(71);
    }

    private final void QuadData(UpdateOperationWithQuads operation) throws ParseException {
        this.jj_consume_token(70);
        this.Quads(operation);
        this.jj_consume_token(71);
    }

    private final void Quads(UpdateOperationWithQuads operation) throws ParseException {
        Set<TriplePattern> triplePatterns;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 67: 
            case 84: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                triplePatterns = this.TriplesTemplate();
                operation.addQuad(triplePatterns);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block12;
                }
            }
            this.QuadsNotTriples(operation);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: {
                    this.jj_consume_token(75);
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 30: 
                case 67: 
                case 84: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 124: {
                    triplePatterns = this.TriplesTemplate();
                    operation.addQuad(triplePatterns);
                    continue block12;
                }
            }
            this.jj_la1[57] = this.jj_gen;
        }
    }

    private final void QuadsNotTriples(UpdateOperationWithQuads operation) throws ParseException {
        Set<TriplePattern> triplePatterns = null;
        this.jj_consume_token(13);
        UriRefOrVariable graph = this.VarOrIri();
        this.jj_consume_token(70);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 67: 
            case 84: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                triplePatterns = this.TriplesTemplate();
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        this.jj_consume_token(71);
        operation.addQuad(graph, triplePatterns);
    }

    private final Set<TriplePattern> TriplesTemplate() throws ParseException {
        Set<TriplePattern> triplePatterns = this.TriplesSameSubject();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: 
                    case 30: 
                    case 67: 
                    case 84: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 124: {
                        Set<TriplePattern> t = this.TriplesTemplate();
                        triplePatterns.addAll(t);
                        break block0;
                    }
                }
                this.jj_la1[59] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        return triplePatterns;
    }

    private final GroupGraphPattern GroupGraphPattern() throws ParseException {
        SimpleGroupGraphPattern groupGraphPattern = new SimpleGroupGraphPattern();
        this.jj_consume_token(70);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Query query = this.SubSelect();
                groupGraphPattern.setSubSelect((SelectQuery)query);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.GroupGraphPatternSub(groupGraphPattern);
            }
        }
        this.jj_consume_token(71);
        return groupGraphPattern;
    }

    private final void GroupGraphPatternSub(GroupGraphPattern groupGraphPattern) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 67: 
            case 84: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                this.TriplesBlock(groupGraphPattern);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 18: 
                case 25: 
                case 31: 
                case 34: 
                case 35: 
                case 36: 
                case 70: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block12;
                }
            }
            this.GraphPatternNotTriples(groupGraphPattern);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: {
                    this.jj_consume_token(75);
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 30: 
                case 67: 
                case 84: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 124: {
                    this.TriplesBlock(groupGraphPattern);
                    continue block12;
                }
            }
            this.jj_la1[65] = this.jj_gen;
        }
    }

    private final void TriplesBlock(GroupGraphPattern groupGraphPattern) throws ParseException {
        Set<PropertyPathPattern> propertyPathPatterns = this.TriplesSameSubjectPath();
        ((SimpleGroupGraphPattern)groupGraphPattern).addPropertyPathPatterns(propertyPathPatterns);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: 
                    case 30: 
                    case 67: 
                    case 84: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 124: {
                        this.TriplesBlock(groupGraphPattern);
                        break block0;
                    }
                }
                this.jj_la1[66] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
    }

    private final void GraphPatternNotTriples(GroupGraphPattern groupGraphPattern) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                this.GroupOrUnionGraphPattern(groupGraphPattern);
                break;
            }
            case 18: {
                this.OptionalGraphPattern(groupGraphPattern);
                break;
            }
            case 35: {
                this.MinusGraphPattern(groupGraphPattern);
                break;
            }
            case 13: {
                this.GraphGraphPattern(groupGraphPattern);
                break;
            }
            case 36: {
                this.ServiceGraphPattern(groupGraphPattern);
                break;
            }
            case 25: {
                Expression constraint = this.Filter();
                ((SimpleGroupGraphPattern)groupGraphPattern).addConstraint(constraint);
                break;
            }
            case 34: {
                Variable v = this.Bind();
                ((SimpleGroupGraphPattern)groupGraphPattern).endLastBasicGraphPattern();
                break;
            }
            case 31: {
                this.InlineData(groupGraphPattern);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final void OptionalGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        this.jj_consume_token(18);
        GroupGraphPattern optional = this.GroupGraphPattern();
        ((SimpleGroupGraphPattern)groupGraphPattern).addOptionalGraphPattern(optional);
    }

    private final void GraphGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        this.jj_consume_token(13);
        UriRefOrVariable graph = this.VarOrIri();
        GroupGraphPattern g = this.GroupGraphPattern();
        ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(new SimpleGraphGraphPattern(graph, g));
    }

    private final void ServiceGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        boolean silent = false;
        this.jj_consume_token(36);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                silent = true;
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        UriRefOrVariable service = this.VarOrIri();
        GroupGraphPattern g = this.GroupGraphPattern();
        SimpleServiceGraphPattern simpleServiceGraphPattern = new SimpleServiceGraphPattern(service, g);
        ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(simpleServiceGraphPattern);
        if (silent) {
            simpleServiceGraphPattern.setSilent(true);
        }
    }

    private final Variable Bind() throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(67);
        Expression e = this.Expression();
        this.jj_consume_token(33);
        Variable v = this.Var();
        v.setBoundExpression(e);
        this.jj_consume_token(68);
        return v;
    }

    private final void InlineData(GroupGraphPattern groupGraphPattern) throws ParseException {
        this.jj_consume_token(31);
        InlineData data = this.DataBlock();
        ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(data);
    }

    private final InlineData DataBlock() throws ParseException {
        SimpleInlineData inlineData = new SimpleInlineData();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: 
            case 101: {
                this.InlineDataOneVar(inlineData);
                break;
            }
            case 67: 
            case 122: {
                this.InlineDataFull(inlineData);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return inlineData;
    }

    private final void InlineDataOneVar(InlineData inlineData) throws ParseException {
        Variable var = this.Var();
        ((SimpleInlineData)inlineData).addVariable(var);
        this.jj_consume_token(70);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 30: 
                case 32: 
                case 96: 
                case 97: 
                case 98: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 118: 
                case 119: 
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    break block3;
                }
            }
            Resource val = this.DataBlockValue();
            ArrayList<Resource> values = new ArrayList<Resource>();
            values.add(val);
            ((SimpleInlineData)inlineData).addValues(values);
        }
        this.jj_consume_token(71);
    }

    private final void InlineDataFull(InlineData inlineData) throws ParseException {
        block20: {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 122: {
                    this.jj_consume_token(122);
                    break;
                }
                case 67: {
                    this.jj_consume_token(67);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 100: 
                            case 101: {
                                break;
                            }
                            default: {
                                this.jj_la1[72] = this.jj_gen;
                                break block17;
                            }
                        }
                        Variable var = this.Var();
                        ((SimpleInlineData)inlineData).addVariable(var);
                    }
                    this.jj_consume_token(68);
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(70);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: 
                    case 122: {
                        break;
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                        break block20;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        this.jj_consume_token(67);
                        ArrayList<Resource> values = new ArrayList<Resource>();
                        block19: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 29: 
                                case 30: 
                                case 32: 
                                case 96: 
                                case 97: 
                                case 98: 
                                case 107: 
                                case 108: 
                                case 109: 
                                case 110: 
                                case 111: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 117: 
                                case 118: 
                                case 119: 
                                case 120: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[75] = this.jj_gen;
                                    break block19;
                                }
                            }
                            Resource val = this.DataBlockValue();
                            values.add(val);
                        }
                        this.jj_consume_token(68);
                        ((SimpleInlineData)inlineData).addValues(values);
                        continue block18;
                    }
                    case 122: {
                        this.jj_consume_token(122);
                        ((SimpleInlineData)inlineData).addValues(new ArrayList<Resource>());
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[76] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(71);
    }

    private final Resource DataBlockValue() throws ParseException {
        Resource r = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: {
                r = this.Iri();
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                r = this.RDFLiteral();
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                r = this.NumericLiteral();
                break;
            }
            case 29: 
            case 30: {
                r = this.BooleanLiteral();
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return r;
    }

    private final void MinusGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        this.jj_consume_token(35);
        GroupGraphPattern subtrahend = this.GroupGraphPattern();
        ((SimpleGroupGraphPattern)groupGraphPattern).addMinusGraphPattern(subtrahend);
    }

    private final void GroupOrUnionGraphPattern(GroupGraphPattern groupGraphPattern) throws ParseException {
        SimpleAlternativeGraphPattern unionGraphPattern = null;
        GroupGraphPattern g = this.GroupGraphPattern();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            if (unionGraphPattern == null) {
                unionGraphPattern = new SimpleAlternativeGraphPattern(g);
            }
            g = this.GroupGraphPattern();
            ((SimpleAlternativeGraphPattern)unionGraphPattern).addAlternativeGraphPattern(g);
        }
        if (unionGraphPattern != null) {
            ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(unionGraphPattern);
        } else {
            ((SimpleGroupGraphPattern)groupGraphPattern).addGraphPattern(g);
        }
    }

    private final Expression Filter() throws ParseException {
        this.jj_consume_token(25);
        Expression c = this.Constraint();
        return c;
    }

    private final Expression Constraint() throws ParseException {
        Expression c;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                c = this.BrackettedExpression();
                break;
            }
            case 27: 
            case 28: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 103: {
                c = this.BuiltInCall();
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                c = this.FunctionCall();
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return c;
    }

    private final FunctionCall FunctionCall() throws ParseException {
        UriRef name = this.Iri();
        List<Expression> arguments = this.ArgList();
        return new FunctionCall(name, arguments);
    }

    private final List<Expression> ArgList() throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[80] = this.jj_gen;
                    }
                }
                Expression e = this.Expression();
                args.add(e);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: {
                            break;
                        }
                        default: {
                            this.jj_la1[81] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(76);
                    e = this.Expression();
                    args.add(e);
                }
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return args;
    }

    private final List<Expression> ExpressionList() throws ParseException {
        ArrayList<Expression> args = new ArrayList<Expression>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                Expression e = this.Expression();
                args.add(e);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: {
                            break;
                        }
                        default: {
                            this.jj_la1[83] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(76);
                    e = this.Expression();
                    args.add(e);
                }
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return args;
    }

    private final Set<TriplePattern> ConstructTemplate() throws ParseException {
        Set<TriplePattern> triplePatterns = null;
        this.jj_consume_token(70);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 67: 
            case 84: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                triplePatterns = this.ConstructTriples();
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
            }
        }
        this.jj_consume_token(71);
        return triplePatterns;
    }

    private final Set<TriplePattern> ConstructTriples() throws ParseException {
        Set<TriplePattern> triplePatterns = this.TriplesSameSubject();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: 
                    case 30: 
                    case 67: 
                    case 84: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 122: 
                    case 124: {
                        Set<TriplePattern> t = this.ConstructTriples();
                        triplePatterns.addAll(t);
                        break block0;
                    }
                }
                this.jj_la1[86] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        return triplePatterns;
    }

    private final Set<TriplePattern> TriplesSameSubject() throws ParseException {
        LinkedHashSet<TriplePattern> triplePatterns = new LinkedHashSet<TriplePattern>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                ResourceOrVariable subject = this.VarOrTerm();
                this.PropertyListNotEmpty(subject, triplePatterns);
                return triplePatterns;
            }
            case 67: 
            case 84: {
                ResourceOrVariable subject = this.TriplesNode(triplePatterns);
                this.PropertyList(subject, triplePatterns);
                return triplePatterns;
            }
        }
        this.jj_la1[88] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final void PropertyList(ResourceOrVariable subject, Set<TriplePattern> triplePatterns) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                this.PropertyListNotEmpty(subject, triplePatterns);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
    }

    private final void PropertyListNotEmpty(ResourceOrVariable subject, Set<TriplePattern> triplePatterns) throws ParseException {
        UriRefOrVariable predicate = this.Verb();
        Set<ResourceOrVariable> objects = this.ObjectList(triplePatterns);
        this.addTriplePatterns(triplePatterns, subject, predicate, objects);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(74);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: {
                    predicate = this.Verb();
                    objects = this.ObjectList(triplePatterns);
                    this.addTriplePatterns(triplePatterns, subject, predicate, objects);
                    continue block6;
                }
            }
            this.jj_la1[91] = this.jj_gen;
        }
    }

    private final UriRefOrVariable Verb() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                UriRefOrVariable predicate = this.VarOrIri();
                return predicate;
            }
            case 77: {
                this.jj_consume_token(77);
                return new UriRefOrVariable(RDF_TYPE);
            }
        }
        this.jj_la1[92] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Set<ResourceOrVariable> ObjectList(Set<TriplePattern> triplePatterns) throws ParseException {
        LinkedHashSet<ResourceOrVariable> objects = new LinkedHashSet<ResourceOrVariable>();
        ResourceOrVariable object = this.Object(triplePatterns);
        objects.add(object);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(76);
            object = this.Object(triplePatterns);
            objects.add(object);
        }
        return objects;
    }

    private final ResourceOrVariable Object(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable object = this.GraphNode(triplePatterns);
        return object;
    }

    private final Set<PropertyPathPattern> TriplesSameSubjectPath() throws ParseException {
        LinkedHashSet<PropertyPathPattern> propertyPathPatterns = new LinkedHashSet<PropertyPathPattern>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                ResourceOrVariable subject = this.VarOrTerm();
                this.PropertyListPathNotEmpty(subject, propertyPathPatterns);
                return propertyPathPatterns;
            }
            case 67: 
            case 84: {
                ResourceOrVariable subject = this.TriplesNodePath(propertyPathPatterns);
                this.PropertyListPath(subject, propertyPathPatterns);
                return propertyPathPatterns;
            }
        }
        this.jj_la1[94] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final void PropertyListPath(ResourceOrVariable subject, Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 77: 
            case 80: 
            case 83: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                this.PropertyListPathNotEmpty(subject, propertyPathPatterns);
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
            }
        }
    }

    private final void PropertyListPathNotEmpty(ResourceOrVariable subject, Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        Variable v;
        PropertyPathExpressionOrVariable propertyPathExpressionOrVariable;
        PropertyPathExpression propertyPathExpression;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 77: 
            case 80: 
            case 83: 
            case 96: 
            case 97: 
            case 98: {
                propertyPathExpression = this.VerbPath();
                propertyPathExpressionOrVariable = new PropertyPathExpressionOrVariable(propertyPathExpression);
                break;
            }
            case 100: 
            case 101: {
                v = this.VerbSimple();
                propertyPathExpressionOrVariable = new PropertyPathExpressionOrVariable(v);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Set<ResourceOrVariable> objects = this.ObjectListPath(propertyPathPatterns);
        this.addPropertyPathPatterns(propertyPathPatterns, subject, propertyPathExpressionOrVariable, objects);
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: {
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(74);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 77: 
                case 80: 
                case 83: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 67: 
                        case 77: 
                        case 80: 
                        case 83: 
                        case 96: 
                        case 97: 
                        case 98: {
                            propertyPathExpression = this.VerbPath();
                            propertyPathExpressionOrVariable = new PropertyPathExpressionOrVariable(propertyPathExpression);
                            break;
                        }
                        case 100: 
                        case 101: {
                            v = this.VerbSimple();
                            propertyPathExpressionOrVariable = new PropertyPathExpressionOrVariable(v);
                            break;
                        }
                        default: {
                            this.jj_la1[98] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    objects = this.ObjectListPath(propertyPathPatterns);
                    this.addPropertyPathPatterns(propertyPathPatterns, subject, propertyPathExpressionOrVariable, objects);
                    continue block14;
                }
            }
            this.jj_la1[99] = this.jj_gen;
        }
    }

    private final PropertyPathExpression VerbPath() throws ParseException {
        PropertyPathExpression propertyPathExpression = this.Path();
        return propertyPathExpression;
    }

    private final Variable VerbSimple() throws ParseException {
        Variable v = this.Var();
        return v;
    }

    private final Set<ResourceOrVariable> ObjectListPath(Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        LinkedHashSet<ResourceOrVariable> objects = new LinkedHashSet<ResourceOrVariable>();
        ResourceOrVariable object = this.ObjectPath(propertyPathPatterns);
        objects.add(object);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(76);
            object = this.ObjectPath(propertyPathPatterns);
            objects.add(object);
        }
        return objects;
    }

    private final ResourceOrVariable ObjectPath(Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        ResourceOrVariable object = this.GraphNodePath(propertyPathPatterns);
        return object;
    }

    private final PropertyPathExpression Path() throws ParseException {
        PropertyPathExpression propertyPathExpression = this.PathAlternative();
        return propertyPathExpression;
    }

    private final PropertyPathExpression PathAlternative() throws ParseException {
        PropertyPathExpression ppe = this.PathSequence();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[101] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(78);
            PropertyPathExpression pathSequence = this.PathSequence();
            ppe = new BinaryPropertyPathOperation("|", ppe, pathSequence);
        }
        return ppe;
    }

    private final PropertyPathExpression PathSequence() throws ParseException {
        PropertyPathExpression ppe = this.PathEltOrInverse();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 79: {
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(79);
            PropertyPathExpression pathEltOrInverse = this.PathEltOrInverse();
            ppe = new BinaryPropertyPathOperation("/", ppe, pathEltOrInverse);
        }
        return ppe;
    }

    private final PropertyPathExpression PathElt() throws ParseException {
        PropertyPathExpression ppe = this.PathPrimary();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: 
            case 81: 
            case 82: {
                String pathMode = this.PathMod();
                ppe = new UnaryPropertyPathOperation(pathMode, ppe);
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
            }
        }
        return ppe;
    }

    private final PropertyPathExpression PathEltOrInverse() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 77: 
            case 83: 
            case 96: 
            case 97: 
            case 98: {
                PropertyPathExpression ppe = this.PathElt();
                return ppe;
            }
            case 80: {
                this.jj_consume_token(80);
                PropertyPathExpression ppe = this.PathElt();
                return new UnaryPropertyPathOperation("^", ppe);
            }
        }
        this.jj_la1[104] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final String PathMod() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                return "?";
            }
            case 69: {
                this.jj_consume_token(69);
                return "*";
            }
            case 82: {
                this.jj_consume_token(82);
                return "+";
            }
        }
        this.jj_la1[105] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final PropertyPathExpression PathPrimary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: {
                UriRef uriRef = this.Iri();
                return new PredicatePath(uriRef);
            }
            case 77: {
                this.jj_consume_token(77);
                return new PredicatePath(RDF_TYPE);
            }
            case 83: {
                this.jj_consume_token(83);
                PropertyPathExpression ppe = this.PathNegatedPropertySet();
                return new UnaryPropertyPathOperation("!", ppe);
            }
            case 67: {
                this.jj_consume_token(67);
                PropertyPathExpression ppe = this.Path();
                return ppe;
            }
        }
        this.jj_la1[106] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final PropertyPathExpression PathNegatedPropertySet() throws ParseException {
        PropertySet propertySet = new PropertySet();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: 
            case 80: 
            case 96: 
            case 97: 
            case 98: {
                PropertyPathExpression pathOneInPropertySet = this.PathOneInPropertySet();
                return pathOneInPropertySet;
            }
            case 67: {
                this.jj_consume_token(67);
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 77: 
                    case 80: 
                    case 96: 
                    case 97: 
                    case 98: {
                        PropertyPathExpression pathOneInPropertySet = this.PathOneInPropertySet();
                        propertySet.addElement(pathOneInPropertySet);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 78: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[107] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(78);
                            pathOneInPropertySet = this.PathOneInPropertySet();
                            propertySet.addElement(pathOneInPropertySet);
                        }
                    }
                    default: {
                        this.jj_la1[108] = this.jj_gen;
                    }
                }
                this.jj_consume_token(68);
                return propertySet;
            }
        }
        this.jj_la1[109] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final PropertyPathExpression PathOneInPropertySet() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: {
                UriRef uriRef = this.Iri();
                return new PredicatePath(uriRef);
            }
            case 77: {
                this.jj_consume_token(77);
                return new PredicatePath(RDF_TYPE);
            }
            case 80: {
                this.jj_consume_token(80);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 96: 
                    case 97: 
                    case 98: {
                        UriRef uriRef = this.Iri();
                        return new UnaryPropertyPathOperation("^", new PredicatePath(uriRef));
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        return new UnaryPropertyPathOperation("^", new PredicatePath(RDF_TYPE));
                    }
                }
                this.jj_la1[110] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[111] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final ResourceOrVariable TriplesNode(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable subject;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                subject = this.Collection(triplePatterns);
                break;
            }
            case 84: {
                subject = this.BlankNodePropertyList(triplePatterns);
                break;
            }
            default: {
                this.jj_la1[112] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return subject;
    }

    private final ResourceOrVariable BlankNodePropertyList(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable subject = this.getNewBNode();
        this.jj_consume_token(84);
        this.PropertyListNotEmpty(subject, triplePatterns);
        this.jj_consume_token(85);
        return subject;
    }

    private final ResourceOrVariable TriplesNodePath(Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        ResourceOrVariable subject;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                subject = this.CollectionPath(propertyPathPatterns);
                break;
            }
            case 84: {
                subject = this.BlankNodePropertyListPath(propertyPathPatterns);
                break;
            }
            default: {
                this.jj_la1[113] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return subject;
    }

    private final ResourceOrVariable BlankNodePropertyListPath(Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        ResourceOrVariable subject = this.getNewBNode();
        this.jj_consume_token(84);
        this.PropertyListPathNotEmpty(subject, propertyPathPatterns);
        this.jj_consume_token(85);
        return subject;
    }

    private final ResourceOrVariable Collection(Set<TriplePattern> triplePatterns) throws ParseException {
        ArrayList<ResourceOrVariable> nodes = new ArrayList<ResourceOrVariable>();
        this.jj_consume_token(67);
        block3: while (true) {
            ResourceOrVariable node = this.GraphNode(triplePatterns);
            nodes.add(node);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 30: 
                case 67: 
                case 84: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 124: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[114] = this.jj_gen;
        this.jj_consume_token(68);
        return this.addTriplePatterns(triplePatterns, nodes);
    }

    private final ResourceOrVariable CollectionPath(Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        ArrayList<ResourceOrVariable> nodes = new ArrayList<ResourceOrVariable>();
        this.jj_consume_token(67);
        block3: while (true) {
            ResourceOrVariable node = this.GraphNodePath(propertyPathPatterns);
            nodes.add(node);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 30: 
                case 67: 
                case 84: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 122: 
                case 124: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[115] = this.jj_gen;
        this.jj_consume_token(68);
        return this.addPropertyPathPatterns(propertyPathPatterns, nodes);
    }

    private final ResourceOrVariable GraphNode(Set<TriplePattern> triplePatterns) throws ParseException {
        ResourceOrVariable node;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                node = this.VarOrTerm();
                break;
            }
            case 67: 
            case 84: {
                node = this.TriplesNode(triplePatterns);
                break;
            }
            default: {
                this.jj_la1[116] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    private final ResourceOrVariable GraphNodePath(Set<PropertyPathPattern> propertyPathPatterns) throws ParseException {
        ResourceOrVariable node;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                node = this.VarOrTerm();
                break;
            }
            case 67: 
            case 84: {
                node = this.TriplesNodePath(propertyPathPatterns);
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    private final ResourceOrVariable VarOrTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: 
            case 101: {
                Variable v = this.Var();
                return new ResourceOrVariable(v);
            }
            case 29: 
            case 30: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                ResourceOrVariable r = this.GraphTerm();
                return r;
            }
        }
        this.jj_la1[118] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final UriRefOrVariable VarOrIri() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: 
            case 101: {
                Variable var = this.Var();
                return new UriRefOrVariable(var);
            }
            case 96: 
            case 97: 
            case 98: {
                UriRef uriRef = this.Iri();
                return new UriRefOrVariable(uriRef);
            }
        }
        this.jj_la1[119] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Variable Var() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 100: {
                t = this.jj_consume_token(100);
                break;
            }
            case 101: {
                t = this.jj_consume_token(101);
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.createVariable(t.image);
    }

    private final ResourceOrVariable GraphTerm() throws ParseException {
        ResourceOrVariable bNode = null;
        Resource r = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: 
            case 97: 
            case 98: {
                r = this.Iri();
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                r = this.RDFLiteral();
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                r = this.NumericLiteral();
                break;
            }
            case 29: 
            case 30: {
                r = this.BooleanLiteral();
                break;
            }
            case 99: 
            case 124: {
                bNode = this.BlankNode();
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                r = RDF_NIL;
                break;
            }
            default: {
                this.jj_la1[121] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (bNode == null) {
            return new ResourceOrVariable(r);
        }
        return bNode;
    }

    private final Expression Expression() throws ParseException {
        Expression e = this.ConditionalOrExpression();
        return e;
    }

    private final Expression ConditionalOrExpression() throws ParseException {
        Expression e = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 86: {
                    break;
                }
                default: {
                    this.jj_la1[122] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(86);
            Expression ae = this.ConditionalAndExpression();
            e = new BinaryOperation("||", e, ae);
        }
        return e;
    }

    private final Expression ConditionalAndExpression() throws ParseException {
        Expression e = this.ValueLogical();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    this.jj_la1[123] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(87);
            Expression e2 = this.ValueLogical();
            e = new BinaryOperation("&&", e, e2);
        }
        return e;
    }

    private final Expression ValueLogical() throws ParseException {
        Expression e = this.RelationalExpression();
        return e;
    }

    private final Expression RelationalExpression() throws ParseException {
        Expression e = this.NumericExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: 
            case 57: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 88: {
                        this.jj_consume_token(88);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("=", e, e2);
                        break block0;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("!=", e, e2);
                        break block0;
                    }
                    case 90: {
                        this.jj_consume_token(90);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("<", e, e2);
                        break block0;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation(">", e, e2);
                        break block0;
                    }
                    case 92: {
                        this.jj_consume_token(92);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation("<=", e, e2);
                        break block0;
                    }
                    case 93: {
                        this.jj_consume_token(93);
                        Expression e2 = this.NumericExpression();
                        e = new BinaryOperation(">=", e, e2);
                        break block0;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        List<Expression> l = this.ExpressionList();
                        e = new RhsListBinaryOperation("IN", e, l);
                        break block0;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        this.jj_consume_token(56);
                        List<Expression> l = this.ExpressionList();
                        e = new RhsListBinaryOperation("NOT IN", e, l);
                        break block0;
                    }
                }
                this.jj_la1[124] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
            }
        }
        return e;
    }

    private final Expression NumericExpression() throws ParseException {
        Expression e = this.AdditiveExpression();
        return e;
    }

    /*
     * Unable to fully structure code
     */
    private final Expression AdditiveExpression() throws ParseException {
        block21: {
            e = this.MultiplicativeExpression();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: 
                    case 94: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        break;
                    }
                    default: {
                        this.jj_la1[126] = this.jj_gen;
                        break block21;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: {
                        this.jj_consume_token(82);
                        e2 = this.MultiplicativeExpression();
                        e = new BinaryOperation("+", e, e2);
                        continue block19;
                    }
                    case 94: {
                        this.jj_consume_token(94);
                        e2 = this.MultiplicativeExpression();
                        e = new BinaryOperation("-", e, e2);
                        continue block19;
                    }
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 110: 
                            case 111: 
                            case 112: {
                                l = this.NumericLiteralPositive();
                                break;
                            }
                            case 113: 
                            case 114: 
                            case 115: {
                                l = this.NumericLiteralNegative();
                                break;
                            }
                            default: {
                                this.jj_la1[127] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        e2 = new LiteralExpression(l);
                        block20: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 69: 
                                case 79: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[128] = this.jj_gen;
                                    ** GOTO lbl60
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 69: {
                                    this.jj_consume_token(69);
                                    u = this.UnaryExpression();
                                    e2 = new BinaryOperation("*", e2, u);
                                    continue block20;
                                }
                                case 79: {
                                    this.jj_consume_token(79);
                                    u = this.UnaryExpression();
                                    e2 = new BinaryOperation("/", e2, u);
                                    continue block20;
                                }
                            }
                            break;
                        }
                        this.jj_la1[129] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
lbl60:
                        // 1 sources

                        e = new BinaryOperation("+", e, e2);
                        continue block19;
                    }
                }
                break;
            }
            this.jj_la1[130] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    private final Expression MultiplicativeExpression() throws ParseException {
        Expression e;
        block8: {
            e = this.UnaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: 
                    case 79: {
                        break;
                    }
                    default: {
                        this.jj_la1[131] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        Expression e2 = this.UnaryExpression();
                        e = new BinaryOperation("*", e, e2);
                        continue block7;
                    }
                    case 79: {
                        this.jj_consume_token(79);
                        Expression e2 = this.UnaryExpression();
                        e = new BinaryOperation("/", e, e2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[132] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    private final Expression UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                this.jj_consume_token(83);
                Expression e = this.PrimaryExpression();
                return new UnaryOperation("!", e);
            }
            case 82: {
                this.jj_consume_token(82);
                Expression e = this.PrimaryExpression();
                return new UnaryOperation("+", e);
            }
            case 94: {
                this.jj_consume_token(94);
                Expression e = this.PrimaryExpression();
                return new UnaryOperation("-", e);
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 103: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                Expression e = this.PrimaryExpression();
                return e;
            }
        }
        this.jj_la1[133] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Expression PrimaryExpression() throws ParseException {
        Expression e = null;
        Literal l = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                e = this.BrackettedExpression();
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                e = this.IriOrFunction();
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                l = this.RDFLiteral();
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                l = this.NumericLiteral();
                break;
            }
            case 29: 
            case 30: {
                l = this.BooleanLiteral();
                break;
            }
            case 100: 
            case 101: {
                e = this.Var();
                break;
            }
            case 27: 
            case 28: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 103: {
                e = this.BuiltInCall();
                break;
            }
            default: {
                this.jj_la1[134] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (l != null) {
            return new LiteralExpression(l);
        }
        return e;
    }

    private final Expression BrackettedExpression() throws ParseException {
        this.jj_consume_token(67);
        Expression e = this.Expression();
        this.jj_consume_token(68);
        return e;
    }

    private final BuiltInCall BuiltInCall() throws ParseException {
        String name;
        ArrayList<Expression> args = new ArrayList();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                name = "GROUP_CONCAT";
                this.jj_consume_token(67);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[135] = this.jj_gen;
                    }
                }
                Expression e = this.Expression();
                args.add(e);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        this.jj_consume_token(74);
                        this.jj_consume_token(66);
                        this.jj_consume_token(88);
                        String s = this.String();
                        break;
                    }
                    default: {
                        this.jj_la1[136] = this.jj_gen;
                    }
                }
                this.jj_consume_token(68);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                name = "BOUND";
                this.jj_consume_token(67);
                Variable e = this.Var();
                args.add(e);
                this.jj_consume_token(68);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                name = "BNODE";
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        this.jj_consume_token(67);
                        Expression e = this.Expression();
                        args.add(e);
                        this.jj_consume_token(68);
                        break block0;
                    }
                    case 122: {
                        this.jj_consume_token(122);
                        break block0;
                    }
                }
                this.jj_la1[137] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 60: {
                this.jj_consume_token(60);
                name = "RAND";
                this.jj_consume_token(122);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                name = "CONCAT";
                args = this.ExpressionList();
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                name = "NOW";
                this.jj_consume_token(122);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                name = "UUID";
                this.jj_consume_token(122);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                name = "STRUUID";
                this.jj_consume_token(122);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                name = "COALESCE";
                args = this.ExpressionList();
                break;
            }
            case 57: {
                Expression e = this.NotExistsFunc();
                return (BuiltInCall)e;
            }
            case 58: {
                Expression e = this.ExistsFunc();
                return (BuiltInCall)e;
            }
            case 103: {
                name = this.BuiltInCallName();
                this.jj_consume_token(67);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        break;
                    }
                    default: {
                        this.jj_la1[138] = this.jj_gen;
                    }
                }
                block27 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 67: 
                    case 82: 
                    case 83: 
                    case 94: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 103: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: {
                        Expression e = this.Expression();
                        args.add(e);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 76: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[139] = this.jj_gen;
                                    break block27;
                                }
                            }
                            this.jj_consume_token(76);
                            e = this.Expression();
                            args.add(e);
                        }
                    }
                    default: {
                        this.jj_la1[140] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new BuiltInCall(name, args);
    }

    private final String BuiltInCallName() throws ParseException {
        Token t = this.jj_consume_token(103);
        return t.image;
    }

    private final Expression ExistsFunc() throws ParseException {
        this.jj_consume_token(58);
        GroupGraphPattern pattern = this.GroupGraphPattern();
        PatternExistenceCondition patternExistenceCondition = new PatternExistenceCondition();
        patternExistenceCondition.setPattern(pattern);
        return patternExistenceCondition;
    }

    private final Expression NotExistsFunc() throws ParseException {
        this.jj_consume_token(57);
        this.jj_consume_token(58);
        GroupGraphPattern pattern = this.GroupGraphPattern();
        PatternExistenceCondition patternExistenceCondition = new PatternExistenceCondition();
        patternExistenceCondition.setPattern(pattern);
        patternExistenceCondition.setExistenceTest(false);
        return patternExistenceCondition;
    }

    private final Expression IriOrFunction() throws ParseException {
        UriRef uriRef = this.Iri();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 122: {
                List<Expression> args = this.ArgList();
                return new FunctionCall(uriRef, args);
            }
        }
        this.jj_la1[142] = this.jj_gen;
        return new UriRefExpression(uriRef);
    }

    private final Literal RDFLiteral() throws ParseException {
        String s = this.String();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 95: 
            case 102: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 102: {
                        Token t = this.jj_consume_token(102);
                        return new PlainLiteralImpl(s, new Language(t.image.substring(1)));
                    }
                    case 95: {
                        this.jj_consume_token(95);
                        UriRef type = this.Iri();
                        return new TypedLiteralImpl(s, type);
                    }
                }
                this.jj_la1[143] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[144] = this.jj_gen;
        return new PlainLiteralImpl(s);
    }

    private final TypedLiteral NumericLiteral() throws ParseException {
        TypedLiteral l;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: 
            case 108: 
            case 109: {
                l = this.NumericLiteralUnsigned();
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                l = this.NumericLiteralPositive();
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                l = this.NumericLiteralNegative();
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return l;
    }

    private final TypedLiteral NumericLiteralUnsigned() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 107: {
                Token t = this.jj_consume_token(107);
                return LiteralFactory.getInstance().createTypedLiteral(Long.valueOf(t.image));
            }
            case 108: {
                Token t = this.jj_consume_token(108);
                return LiteralFactory.getInstance().createTypedLiteral(Float.valueOf(t.image));
            }
            case 109: {
                Token t = this.jj_consume_token(109);
                return LiteralFactory.getInstance().createTypedLiteral(Double.valueOf(t.image));
            }
        }
        this.jj_la1[146] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TypedLiteral NumericLiteralPositive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 110: {
                Token t = this.jj_consume_token(110);
                return LiteralFactory.getInstance().createTypedLiteral(Long.valueOf(t.image));
            }
            case 111: {
                Token t = this.jj_consume_token(111);
                return LiteralFactory.getInstance().createTypedLiteral(Float.valueOf(t.image));
            }
            case 112: {
                Token t = this.jj_consume_token(112);
                return LiteralFactory.getInstance().createTypedLiteral(Double.valueOf(t.image));
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TypedLiteral NumericLiteralNegative() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 113: {
                Token t = this.jj_consume_token(113);
                return LiteralFactory.getInstance().createTypedLiteral(Long.valueOf(t.image));
            }
            case 114: {
                Token t = this.jj_consume_token(114);
                return LiteralFactory.getInstance().createTypedLiteral(Float.valueOf(t.image));
            }
            case 115: {
                Token t = this.jj_consume_token(115);
                return LiteralFactory.getInstance().createTypedLiteral(Double.valueOf(t.image));
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final TypedLiteral BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                return LiteralFactory.getInstance().createTypedLiteral(true);
            }
            case 30: {
                this.jj_consume_token(30);
                return LiteralFactory.getInstance().createTypedLiteral(false);
            }
        }
        this.jj_la1[149] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final String String() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 117: {
                Token t = this.jj_consume_token(117);
                return JavaCCGeneratedSparqlPreParser.unquote(t.image);
            }
            case 118: {
                Token t = this.jj_consume_token(118);
                return JavaCCGeneratedSparqlPreParser.unquote(t.image);
            }
            case 119: {
                Token t = this.jj_consume_token(119);
                return JavaCCGeneratedSparqlPreParser.unTripleQuote(t.image);
            }
            case 120: {
                Token t = this.jj_consume_token(120);
                return JavaCCGeneratedSparqlPreParser.unTripleQuote(t.image);
            }
        }
        this.jj_la1[150] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final UriRef Iri() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 96: {
                Token t = this.jj_consume_token(96);
                return this.createUriRef(JavaCCGeneratedSparqlPreParser.unquote(t.image));
            }
            case 97: 
            case 98: {
                UriRef uriRef = this.PrefixedName();
                return uriRef;
            }
        }
        this.jj_la1[151] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final UriRef PrefixedName() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                t = this.jj_consume_token(98);
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                break;
            }
            default: {
                this.jj_la1[152] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.createUriRef(t.image);
    }

    private final ResourceOrVariable BlankNode() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: {
                Token t = this.jj_consume_token(99);
                return this.getBNode(t.image);
            }
            case 124: {
                this.jj_consume_token(124);
                return this.getNewBNode();
            }
        }
        this.jj_la1[153] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private boolean jj_3_2() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_37() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_38() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_scan_token(51);
    }

    private boolean jj_3_1() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_39() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        return this.jj_scan_token(21);
    }

    private boolean jj_3_3() {
        return this.jj_3R_39();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x888100, 0x888100, 16896, 16896, 4096, 0x5000000, 0x5000000, 0, 0, 0, 4096, 4096, 0x60000000, 0x201000, 0, 0, 4096, 0x200000, 4096, 131072, 0x200000, 0, 0, 1024, 0x110000, 0x18000000, 0, 0x18000000, 0x18000000, 0x18000000, 0, 0x18000000, 0x18000000, 0x100000, 65536, 0x110000, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 8192, 8192, 139264, 0x60000000, 8192, 0, 0x60000000, 0x60000000, 0x60000000, 0, 256, 0x60000000, -2113658880, 0, 0x60000000, 0x60000000, 0, -2113658880, 0, 0, 0x60000000, 0, 0, 0, 0x60000000, 0, 0x60000000, 0x400000, 0x18000000, 0x1000000, 0, 0, 0, 0, 0x60000000, 0x60000000, 0, 0x60000000, 0, 0, 0, 0, 0, 0x60000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60000000, 0x60000000, 0x60000000, 0x60000000, 0x60000000, 0, 0, 0x60000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x78000000, 0x78000000, 0x1000000, 0, 0, 0x1000000, 0, 0x78000000, 0x18000000, 0, 0, 0, 0, 0, 0, 0, 0x60000000, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 64, 0, 0, -33554432, 2, -33554432, -33554432, -33554432, 0, -33554432, -33554432, 0, 0, 0, 0, 0, 1555584, 113792, 0x160000, 256, 512, 256, 256, 256, 0x100000, 131072, 393216, 0x200000, 0, 0, 0x400000, 0xC00000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 28, 256, 0, 1, 0, 0, 0, 1, 0, 1, 0, -33554432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3000000, 0x3000000, 0, 0, 0, 0, 0, 0, 0, -33554432, -33554432, 0, 0, 0, 0, 0, -33554432, -33554432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 8, 8, 40, 0, 0, 0x100008, 64, 0, 32, 0, 64, 0, 0, 0, 0, 0, 0, 0, 11, 0, 11, 11, 779, 768, 11, 779, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100008, 0, 2048, 0x100008, 0x100008, 0x100008, 2048, 0, 0x100008, 64, 2048, 0x100008, 0x100008, 2048, 64, 0, 8, 0, 0, 8, 8, 0, 8, 0, 0, 11, 0, 4096, 8, 4096, 8, 0x100008, 0x100008, 2048, 0x100008, 8192, 1024, 8192, 8192, 4096, 0x100008, 598024, 598024, 1024, 598024, 598024, 4096, 16384, 32768, 393248, 598024, 393248, 532488, 16384, 73728, 73736, 8192, 73728, 0x100008, 0x100008, 0x100008, 0x100008, 0x100008, 0x100008, 0, 0, 0, 0, 0x400000, 0x800000, 0x3F000000, 0x3F000000, 0x40040000, 0, 32800, 32800, 0x40040000, 32800, 32800, 1074528267, 11, 0, 1024, 8, 0, 4096, 1074528299, 3, 8, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 0, 0, 368048191, 0, 55, 55, 0, 0, 0, 7, 0, 0, 0, 0, 0, 183, 0, 183, 135, 183, 0, 183, 183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 368048191, 0, 0, 368048191, 368048191, 368048191, 0, 0, 368048191, 0, 0, 368048191, 368048191, 0, 0, 0, 0x4000030, 32503815, 48, 0x4000000, 0x4000000, 32503815, 0x4000000, 32503815, 0, 135, 0, 0, 0x4000000, 0, 0x4000000, 368048191, 368048191, 0, 368048191, 55, 0, 55, 55, 0, 368048191, 55, 55, 0, 55, 55, 0, 0, 0, 0, 7, 0, 7, 0, 7, 7, 7, 7, 0, 0, 368048191, 368048191, 368048191, 368048191, 368048191, 55, 48, 368048143, 0, 0, 0, 0, 1032192, 1032192, 0, 0, 1032192, 0, 0, 32503991, 32503991, 0, 0, 0x4000000, 0, 0, 32503991, 128, 0x4000000, 64, 64, 1046528, 14336, 114688, 917504, 0, 0x1E00000, 7, 6, 0x10000008};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public JavaCCGeneratedSparqlPreParser(InputStream stream) {
        this(stream, null);
    }

    public JavaCCGeneratedSparqlPreParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JavaCCGeneratedSparqlPreParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 154; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 154; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JavaCCGeneratedSparqlPreParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JavaCCGeneratedSparqlPreParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 154; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 154; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public JavaCCGeneratedSparqlPreParser(JavaCCGeneratedSparqlPreParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 154; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(JavaCCGeneratedSparqlPreParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 154; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[135];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 154; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 135; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        JavaCCGeneratedSparqlPreParser.jj_la1_init_0();
        JavaCCGeneratedSparqlPreParser.jj_la1_init_1();
        JavaCCGeneratedSparqlPreParser.jj_la1_init_2();
        JavaCCGeneratedSparqlPreParser.jj_la1_init_3();
        JavaCCGeneratedSparqlPreParser.jj_la1_init_4();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private class GraphRefAllSpec {
        UpdateOperation.GraphSpec graphSpec;
        UriRef graph;

        private GraphRefAllSpec() {
        }

        public void setGraphSpec(UpdateOperation.GraphSpec graphSpec) {
            this.graphSpec = graphSpec;
        }

        public UpdateOperation.GraphSpec getGraphSpec() {
            return this.graphSpec;
        }

        public void setGraph(UriRef graph) {
            this.graph = graph;
        }

        public UriRef getGraph() {
            return this.graph;
        }
    }
}

