/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql;

import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.TcProvider;
import org.apache.clerezza.rdf.core.sparql.JavaCCGeneratedSparqlPreParser;
import org.apache.clerezza.rdf.core.sparql.ParseException;
import org.apache.clerezza.rdf.core.sparql.query.AlternativeGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.DataSet;
import org.apache.clerezza.rdf.core.sparql.query.GraphGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.MinusGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.OptionalGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.Query;
import org.apache.clerezza.rdf.core.sparql.query.SelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.SparqlUnit;
import org.apache.clerezza.rdf.core.sparql.update.Update;

public class SparqlPreParser {
    TcProvider tcProvider;

    public SparqlPreParser() {
    }

    public SparqlPreParser(TcProvider tcProvider) {
        this.tcProvider = tcProvider;
    }

    public Set<UriRef> getReferredGraphs(String queryString, UriRef defaultGraph) throws ParseException {
        Set<UriRef> referredGraphs;
        JavaCCGeneratedSparqlPreParser parser = new JavaCCGeneratedSparqlPreParser(new StringReader(queryString));
        SparqlUnit sparqlUnit = parser.parse();
        boolean referringVariableNamedGraph = false;
        if (sparqlUnit.isQuery()) {
            Query q = sparqlUnit.getQuery();
            DataSet dataSet = q.getDataSet();
            if (dataSet != null) {
                referredGraphs = dataSet.getDefaultGraphs();
                referredGraphs.addAll(dataSet.getNamedGraphs());
            } else {
                referredGraphs = new HashSet<UriRef>();
            }
            GroupGraphPattern queryPattern = q.getQueryPattern();
            if (queryPattern != null) {
                Set<GraphPattern> graphPatterns = queryPattern.getGraphPatterns();
                for (GraphPattern graphPattern : graphPatterns) {
                }
            }
            referringVariableNamedGraph = this.referringVariableNamedGraph(q);
        } else {
            Update u = sparqlUnit.getUpdate();
            referredGraphs = u.getReferredGraphs(defaultGraph, this.tcProvider);
        }
        if (referredGraphs.isEmpty()) {
            if (referringVariableNamedGraph) {
                return null;
            }
            referredGraphs.add(defaultGraph);
        }
        return referredGraphs;
    }

    private boolean referringVariableNamedGraph(Query query) {
        GroupGraphPattern queryPattern = query.getQueryPattern();
        if (queryPattern == null) {
            return false;
        }
        Set<GraphPattern> graphPatterns = queryPattern.getGraphPatterns();
        return this.referringVariableNamedGraph(graphPatterns);
    }

    private boolean referringVariableNamedGraph(Set<GraphPattern> graphPatterns) {
        boolean referringVariableNamedGraph = false;
        for (GraphPattern graphPattern : graphPatterns) {
            if (!this.referringVariableNamedGraph(graphPattern)) continue;
            referringVariableNamedGraph = true;
            break;
        }
        return referringVariableNamedGraph;
    }

    private boolean referringVariableNamedGraph(GraphPattern graphPattern) {
        if (graphPattern instanceof GraphGraphPattern) {
            return ((GraphGraphPattern)graphPattern).getGraph().isVariable();
        }
        if (graphPattern instanceof AlternativeGraphPattern) {
            List<GroupGraphPattern> alternativeGraphPatterns = ((AlternativeGraphPattern)graphPattern).getAlternativeGraphPatterns();
            boolean referringVariableNamedGraph = false;
            for (GroupGraphPattern groupGraphPattern : alternativeGraphPatterns) {
                if (!this.referringVariableNamedGraph(groupGraphPattern)) continue;
                referringVariableNamedGraph = true;
                break;
            }
            return referringVariableNamedGraph;
        }
        if (graphPattern instanceof OptionalGraphPattern) {
            GraphPattern mainGraphPattern = ((OptionalGraphPattern)graphPattern).getMainGraphPattern();
            if (this.referringVariableNamedGraph(mainGraphPattern)) {
                return true;
            }
            GroupGraphPattern optionalGraphPattern = ((OptionalGraphPattern)graphPattern).getOptionalGraphPattern();
            return this.referringVariableNamedGraph(optionalGraphPattern);
        }
        if (graphPattern instanceof MinusGraphPattern) {
            GraphPattern minuendGraphPattern = ((MinusGraphPattern)graphPattern).getMinuendGraphPattern();
            if (this.referringVariableNamedGraph(minuendGraphPattern)) {
                return true;
            }
            GroupGraphPattern subtrahendGraphPattern = ((MinusGraphPattern)graphPattern).getSubtrahendGraphPattern();
            return this.referringVariableNamedGraph(subtrahendGraphPattern);
        }
        if (graphPattern instanceof GroupGraphPattern) {
            GroupGraphPattern groupGraphPattern = (GroupGraphPattern)graphPattern;
            if (groupGraphPattern.isSubSelect()) {
                SelectQuery query = ((GroupGraphPattern)graphPattern).getSubSelect();
                return this.referringVariableNamedGraph(query);
            }
            Set<GraphPattern> graphPatterns = ((GroupGraphPattern)graphPattern).getGraphPatterns();
            return this.referringVariableNamedGraph(graphPatterns);
        }
        return false;
    }
}

