/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.clerezza.rdf.core.sparql.query.BuiltInCall;
import org.apache.clerezza.rdf.core.sparql.query.Expression;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;

public class PatternExistenceCondition
extends BuiltInCall {
    private boolean negated = false;
    private GroupGraphPattern pattern;

    public PatternExistenceCondition() {
        super("EXISTS", new ArrayList<Expression>());
    }

    public PatternExistenceCondition(String name, List<Expression> arguments) {
        super(name, new ArrayList<Expression>());
        if (!name.equalsIgnoreCase("EXISTS") && !name.equalsIgnoreCase("NOT EXISTS")) {
            throw new RuntimeException("Unsupported name: " + name);
        }
        this.negated = name.equalsIgnoreCase("NOT EXISTS");
    }

    public boolean isExistenceTest() {
        return !this.negated;
    }

    public GroupGraphPattern getPattern() {
        return this.pattern;
    }

    public void setExistenceTest(boolean existenceTest) {
        this.negated = !existenceTest;
        this.name = existenceTest ? "EXISTS" : "NOT EXISTS";
    }

    public void setPattern(GroupGraphPattern pattern) {
        this.pattern = pattern;
    }
}

