/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query;

import java.util.UUID;
import org.apache.clerezza.rdf.core.sparql.query.Expression;

public class Variable
implements Expression {
    private String name;
    private Expression boundExpression;

    public Variable() {
        this.name = UUID.randomUUID().toString();
    }

    public Variable(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name may not be null");
        }
        this.name = name;
    }

    public Variable(String name, Expression boundExpression) {
        this.name = name;
        this.boundExpression = boundExpression;
    }

    public String getName() {
        return this.name;
    }

    public Expression getBoundExpression() {
        return this.boundExpression;
    }

    public void setBoundExpression(Expression boundExpression) {
        this.boundExpression = boundExpression;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

