/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.sparql.query.AlternativeGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.BasicGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.Expression;
import org.apache.clerezza.rdf.core.sparql.query.GraphGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.MinusGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.OptionalGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.PathSupportedBasicGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathPattern;
import org.apache.clerezza.rdf.core.sparql.query.SelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.UriRefOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleBasicGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleMinusGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleOptionalGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimplePathSupportedBasicGraphPattern;

public class SimpleGroupGraphPattern
implements GroupGraphPattern {
    private List<Expression> constraints = new ArrayList<Expression>();
    private List<GraphPattern> graphPatterns = new ArrayList<GraphPattern>();
    private SelectQuery subSelect = null;
    private boolean lastBasicGraphPatternIsComplete = true;

    @Override
    public boolean isSubSelect() {
        return this.subSelect != null;
    }

    @Override
    public SelectQuery getSubSelect() {
        return this.subSelect;
    }

    @Override
    public Set<GraphPattern> getGraphPatterns() {
        return this.subSelect == null ? new LinkedHashSet<GraphPattern>(this.graphPatterns) : null;
    }

    @Override
    public List<Expression> getFilter() {
        return this.subSelect == null ? this.constraints : null;
    }

    public void setSubSelect(SelectQuery subSelect) {
        this.subSelect = subSelect;
    }

    public void addGraphPattern(GraphPattern graphPattern) {
        this.subSelect = null;
        this.graphPatterns.add(graphPattern);
        this.lastBasicGraphPatternIsComplete = !(graphPattern instanceof BasicGraphPattern) && !(graphPattern instanceof PathSupportedBasicGraphPattern);
    }

    public void addConstraint(Expression constraint) {
        this.subSelect = null;
        this.constraints.add(constraint);
    }

    public void endLastBasicGraphPattern() {
        this.lastBasicGraphPatternIsComplete = true;
    }

    public void addPropertyPathPatterns(Set<PropertyPathPattern> propertyPathPatterns) {
        this.subSelect = null;
        if (this.lastBasicGraphPatternIsComplete) {
            this.graphPatterns.add(new SimplePathSupportedBasicGraphPattern(propertyPathPatterns));
            this.lastBasicGraphPatternIsComplete = false;
        } else {
            int size = this.graphPatterns.size();
            GraphPattern prevGraphPattern = this.graphPatterns.get(size - 1);
            if (prevGraphPattern instanceof SimplePathSupportedBasicGraphPattern) {
                ((SimplePathSupportedBasicGraphPattern)prevGraphPattern).addPropertyPathPatterns(propertyPathPatterns);
            }
        }
    }

    public void addTriplePatterns(Set<TriplePattern> triplePatterns) {
        GraphPattern prevGraphPattern;
        this.subSelect = null;
        int size = this.graphPatterns.size();
        if (!this.lastBasicGraphPatternIsComplete && size > 0 && (prevGraphPattern = this.graphPatterns.get(size - 1)) instanceof SimpleBasicGraphPattern) {
            ((SimpleBasicGraphPattern)prevGraphPattern).addTriplePatterns(triplePatterns);
            return;
        }
        this.graphPatterns.add(new SimpleBasicGraphPattern(triplePatterns));
        this.lastBasicGraphPatternIsComplete = false;
    }

    public void addOptionalGraphPattern(GroupGraphPattern optional) {
        this.subSelect = null;
        GraphPattern prevGraphPattern = null;
        int size = this.graphPatterns.size();
        if (size > 0) {
            prevGraphPattern = this.graphPatterns.remove(size - 1);
        }
        this.graphPatterns.add(new SimpleOptionalGraphPattern(prevGraphPattern, optional));
        this.lastBasicGraphPatternIsComplete = true;
    }

    public void addMinusGraphPattern(GroupGraphPattern subtrahend) {
        this.subSelect = null;
        GraphPattern prevGraphPattern = null;
        int size = this.graphPatterns.size();
        if (size > 0) {
            prevGraphPattern = this.graphPatterns.remove(size - 1);
        }
        this.graphPatterns.add(new SimpleMinusGraphPattern(prevGraphPattern, subtrahend));
        this.lastBasicGraphPatternIsComplete = true;
    }

    @Override
    public Set<UriRef> getReferredGraphs() {
        HashSet<UriRef> referredGraphs = new HashSet<UriRef>();
        if (this.subSelect != null) {
            GroupGraphPattern queryPattern = this.subSelect.getQueryPattern();
            referredGraphs.addAll(queryPattern.getReferredGraphs());
        } else {
            for (GraphPattern graphPattern : this.graphPatterns) {
                referredGraphs.addAll(this.getReferredGraphs(graphPattern));
            }
        }
        return referredGraphs;
    }

    private Set<UriRef> getReferredGraphs(GraphPattern graphPattern) {
        HashSet<UriRef> referredGraphs = new HashSet<UriRef>();
        if (graphPattern instanceof GraphGraphPattern) {
            GraphGraphPattern graphGraphPattern = (GraphGraphPattern)graphPattern;
            UriRefOrVariable graph = graphGraphPattern.getGraph();
            if (!graph.isVariable()) {
                referredGraphs.add(graph.getResource());
            }
            referredGraphs.addAll(graphGraphPattern.getGroupGraphPattern().getReferredGraphs());
        } else if (graphPattern instanceof AlternativeGraphPattern) {
            List<GroupGraphPattern> alternativeGraphPatterns = ((AlternativeGraphPattern)graphPattern).getAlternativeGraphPatterns();
            for (GroupGraphPattern groupGraphPattern : alternativeGraphPatterns) {
                referredGraphs.addAll(groupGraphPattern.getReferredGraphs());
            }
        } else if (graphPattern instanceof OptionalGraphPattern) {
            GraphPattern mainGraphPattern = ((OptionalGraphPattern)graphPattern).getMainGraphPattern();
            referredGraphs.addAll(this.getReferredGraphs(mainGraphPattern));
            GroupGraphPattern optionalGraphPattern = ((OptionalGraphPattern)graphPattern).getOptionalGraphPattern();
            referredGraphs.addAll(optionalGraphPattern.getReferredGraphs());
        } else if (graphPattern instanceof MinusGraphPattern) {
            GraphPattern minuendGraphPattern = ((MinusGraphPattern)graphPattern).getMinuendGraphPattern();
            referredGraphs.addAll(this.getReferredGraphs(minuendGraphPattern));
            GroupGraphPattern subtrahendGraphPattern = ((MinusGraphPattern)graphPattern).getSubtrahendGraphPattern();
            referredGraphs.addAll(subtrahendGraphPattern.getReferredGraphs());
        } else if (graphPattern instanceof GroupGraphPattern) {
            GroupGraphPattern groupGraphPattern = (GroupGraphPattern)graphPattern;
            referredGraphs.addAll(groupGraphPattern.getReferredGraphs());
        }
        return referredGraphs;
    }
}

