/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.query.impl;

import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathExpression;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathExpressionOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.PropertyPathPattern;
import org.apache.clerezza.rdf.core.sparql.query.ResourceOrVariable;
import org.apache.clerezza.rdf.core.sparql.query.Variable;

public class SimplePropertyPathPattern
implements PropertyPathPattern {
    private ResourceOrVariable subject;
    private PropertyPathExpressionOrVariable propertyPathExpression;
    private ResourceOrVariable object;

    public SimplePropertyPathPattern(ResourceOrVariable subject, PropertyPathExpressionOrVariable propertyPathExpression, ResourceOrVariable object) {
        if (subject == null) {
            throw new IllegalArgumentException("Invalid subject: null");
        }
        if (propertyPathExpression == null) {
            throw new IllegalArgumentException("Invalid property path expression: null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Invalid object: null");
        }
        this.subject = subject;
        this.propertyPathExpression = propertyPathExpression;
        this.object = object;
    }

    public SimplePropertyPathPattern(Variable subject, Variable propertyPathExpression, Variable object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(NonLiteral subject, Variable propertyPathExpression, Variable object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(Variable subject, Variable propertyPathExpression, Resource object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(NonLiteral subject, Variable propertyPathExpression, Resource object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(Variable subject, PropertyPathExpression propertyPathExpression, Variable object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(NonLiteral subject, PropertyPathExpression propertyPathExpression, Variable object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(Variable subject, PropertyPathExpression propertyPathExpression, Resource object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    public SimplePropertyPathPattern(NonLiteral subject, PropertyPathExpression propertyPathExpression, Resource object) {
        this(new ResourceOrVariable(subject), new PropertyPathExpressionOrVariable(propertyPathExpression), new ResourceOrVariable(object));
    }

    @Override
    public ResourceOrVariable getSubject() {
        return this.subject;
    }

    @Override
    public PropertyPathExpressionOrVariable getPropertyPathExpression() {
        return this.propertyPathExpression;
    }

    @Override
    public ResourceOrVariable getObject() {
        return this.object;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyPathPattern)) {
            return false;
        }
        PropertyPathPattern other = (PropertyPathPattern)obj;
        if (!this.subject.equals(other.getSubject())) {
            return false;
        }
        if (!this.propertyPathExpression.equals(other.getPropertyPathExpression())) {
            return false;
        }
        return this.object.equals(other.getObject());
    }

    public int hashCode() {
        return this.subject.hashCode() >> 1 ^ this.propertyPathExpression.hashCode() ^ this.object.hashCode() << 1;
    }
}

