/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.update.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.TcProvider;
import org.apache.clerezza.rdf.core.sparql.update.UpdateOperation;

public abstract class BaseUpdateOperation
implements UpdateOperation {
    protected Set<UriRef> inputGraphs = new HashSet<UriRef>();
    protected Set<UriRef> destinationGraphs = new HashSet<UriRef>();
    protected UpdateOperation.GraphSpec inputGraphSpec = UpdateOperation.GraphSpec.GRAPH;
    protected UpdateOperation.GraphSpec destinationGraphSpec = UpdateOperation.GraphSpec.GRAPH;

    public void setInputGraphSpec(UpdateOperation.GraphSpec inputGraphSpec) {
        this.inputGraphSpec = inputGraphSpec;
    }

    public UpdateOperation.GraphSpec getInputGraphSpec() {
        return this.inputGraphSpec;
    }

    public void setDestinationGraphSpec(UpdateOperation.GraphSpec destinationGraphSpec) {
        this.destinationGraphSpec = destinationGraphSpec;
    }

    public UpdateOperation.GraphSpec getDestinationGraphSpec() {
        return this.destinationGraphSpec;
    }

    @Override
    public Set<UriRef> getInputGraphs(UriRef defaultGraph, TcProvider tcProvider) {
        return this.getGraphs(defaultGraph, tcProvider, this.inputGraphSpec, this.inputGraphs);
    }

    private Set<UriRef> getGraphs(UriRef defaultGraph, TcProvider tcProvider, UpdateOperation.GraphSpec graphSpec, Set<UriRef> graphs) {
        switch (graphSpec) {
            case DEFAULT: {
                HashSet<UriRef> result = new HashSet<UriRef>();
                result.add(defaultGraph);
                return result;
            }
            case NAMED: 
            case ALL: {
                return tcProvider.listTripleCollections();
            }
        }
        return graphs;
    }

    @Override
    public Set<UriRef> getDestinationGraphs(UriRef defaultGraph, TcProvider tcProvider) {
        return this.getGraphs(defaultGraph, tcProvider, this.destinationGraphSpec, this.destinationGraphs);
    }

    public void addInputGraph(UriRef graph) {
        this.inputGraphs.add(graph);
    }

    public void addDestinationGraph(UriRef graph) {
        this.destinationGraphs.add(graph);
    }
}

