/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.update.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.TcProvider;
import org.apache.clerezza.rdf.core.sparql.query.GroupGraphPattern;
import org.apache.clerezza.rdf.core.sparql.query.impl.SimpleDataSet;
import org.apache.clerezza.rdf.core.sparql.update.UpdateOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.UpdateOperationWithQuads;

public class ModifyOperation
implements UpdateOperation {
    private UriRef fallbackGraph = null;
    private UpdateOperationWithQuads deleteOperation = null;
    private UpdateOperationWithQuads insertOperation = null;
    private SimpleDataSet dataSet = null;
    private GroupGraphPattern queryPattern = null;

    public void setFallbackGraph(UriRef fallbackGraph) {
        this.fallbackGraph = fallbackGraph;
    }

    public void setDeleteOperation(UpdateOperationWithQuads deleteOperation) {
        this.deleteOperation = deleteOperation;
    }

    public void setInsertOperation(UpdateOperationWithQuads insertOperation) {
        this.insertOperation = insertOperation;
    }

    public void setDataSet(SimpleDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public void addGraphToDataSet(UriRef graph) {
        if (this.dataSet == null) {
            this.dataSet = new SimpleDataSet();
        }
        this.dataSet.addDefaultGraph(graph);
    }

    public void addNamedGraphToDataSet(UriRef namedGraph) {
        if (this.dataSet == null) {
            this.dataSet = new SimpleDataSet();
        }
        this.dataSet.addNamedGraph(namedGraph);
    }

    public void setQueryPattern(GroupGraphPattern queryPattern) {
        this.queryPattern = queryPattern;
    }

    @Override
    public Set<UriRef> getInputGraphs(UriRef defaultGraph, TcProvider tcProvider) {
        HashSet<UriRef> graphs = new HashSet<UriRef>();
        if (this.dataSet != null) {
            graphs.addAll(this.dataSet.getDefaultGraphs());
            graphs.addAll(this.dataSet.getNamedGraphs());
        } else if (this.fallbackGraph != null) {
            graphs.add(this.fallbackGraph);
        }
        if (graphs.isEmpty()) {
            graphs.add(defaultGraph);
        }
        if (this.queryPattern != null) {
            graphs.addAll(this.queryPattern.getReferredGraphs());
        }
        return graphs;
    }

    @Override
    public Set<UriRef> getDestinationGraphs(UriRef defaultGraph, TcProvider tcProvider) {
        UriRef dfltGraph;
        HashSet<UriRef> graphs = new HashSet<UriRef>();
        UriRef uriRef = dfltGraph = this.fallbackGraph != null ? this.fallbackGraph : defaultGraph;
        if (this.deleteOperation != null) {
            graphs.addAll(this.deleteOperation.getDestinationGraphs(dfltGraph, tcProvider));
        }
        if (this.insertOperation != null) {
            graphs.addAll(this.insertOperation.getDestinationGraphs(dfltGraph, tcProvider));
        }
        return graphs;
    }
}

