/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.sparql.update.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.TcProvider;
import org.apache.clerezza.rdf.core.sparql.query.TriplePattern;
import org.apache.clerezza.rdf.core.sparql.query.UriRefOrVariable;
import org.apache.clerezza.rdf.core.sparql.update.UpdateOperation;
import org.apache.clerezza.rdf.core.sparql.update.impl.Quad;

public class UpdateOperationWithQuads
implements UpdateOperation {
    private Quad defaultQuad = null;
    private List<Quad> quads = new ArrayList<Quad>();

    public void addQuad(Set<TriplePattern> triplePatterns) {
        if (this.defaultQuad == null) {
            this.defaultQuad = new Quad(null, triplePatterns);
        } else {
            this.defaultQuad.addTriplePatterns(triplePatterns);
        }
    }

    public void addQuad(UriRefOrVariable graph, Set<TriplePattern> triplePatterns) {
        if (graph == null) {
            this.addQuad(triplePatterns);
        } else {
            this.quads.add(new Quad(graph, triplePatterns));
        }
    }

    @Override
    public Set<UriRef> getInputGraphs(UriRef defaultGraph, TcProvider tcProvider) {
        return new HashSet<UriRef>();
    }

    @Override
    public Set<UriRef> getDestinationGraphs(UriRef defaultGraph, TcProvider tcProvider) {
        HashSet<UriRef> graphs = new HashSet<UriRef>();
        if (this.defaultQuad != null) {
            graphs.add(defaultGraph);
        }
        for (Quad quad : this.quads) {
            UriRefOrVariable graph = quad.getGraph();
            if (graph.isVariable()) continue;
            graphs.add(graph.getResource());
        }
        return graphs;
    }
}

