/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.commons;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.util.Map;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Language;
import org.apache.clerezza.rdf.core.Literal;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;
import org.apache.clerezza.rdf.jena.commons.JenaBNodeWrapper;

public class Jena2TriaUtil {
    private final Map<Node, BNode> tria2JenaBNodes;

    public Jena2TriaUtil(Map<Node, BNode> tria2JenaBNodes) {
        this.tria2JenaBNodes = tria2JenaBNodes;
    }

    private BNode convertJenaNode2TriaBlankNode(Node node) {
        BNode result = this.tria2JenaBNodes.get(node);
        if (result == null) {
            result = new JenaBNodeWrapper(node);
        }
        return result;
    }

    private Literal convertJenaLiteral2Literal(Node node) {
        String lexicalForm = node.getLiteralLexicalForm();
        String datatypeString = node.getLiteralDatatypeURI();
        if (datatypeString != null) {
            UriRef dtUriRef = new UriRef(datatypeString);
            return new TypedLiteralImpl(lexicalForm, dtUriRef);
        }
        String language = node.getLiteralLanguage();
        if (language != null && !language.equals("")) {
            return new PlainLiteralImpl(lexicalForm, new Language(language));
        }
        return new PlainLiteralImpl(lexicalForm);
    }

    public UriRef convertJenaUri2UriRef(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        return new UriRef(node.getURI());
    }

    public Resource convertJenaNode2Resource(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        if (node.isBlank()) {
            return this.convertJenaNode2TriaBlankNode(node);
        }
        if (node.isURI()) {
            return this.convertJenaUri2UriRef(node);
        }
        if (node.isLiteral()) {
            return this.convertJenaLiteral2Literal(node);
        }
        throw new RuntimeException("cannot convert " + node + " to Resource");
    }

    public NonLiteral convertNonLiteral(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        if (node.isBlank()) {
            return this.convertJenaNode2TriaBlankNode(node);
        }
        if (node.isURI()) {
            return this.convertJenaUri2UriRef(node);
        }
        throw new RuntimeException("cannot convert " + node + " to NonLiteral");
    }

    public org.apache.clerezza.rdf.core.Triple convertTriple(Triple triple) {
        NonLiteral subject = this.convertNonLiteral(triple.getSubject());
        UriRef predicate = this.convertJenaUri2UriRef(triple.getPredicate());
        Resource object = this.convertJenaNode2Resource(triple.getObject());
        if (subject == null || object == null) {
            return null;
        }
        return new TripleImpl(subject, predicate, object);
    }
}

