/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.commons;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.util.Map;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.Literal;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.PlainLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.jena.commons.JenaBNodeWrapper;

public class Tria2JenaUtil {
    private Map<BNode, Node> tria2JenaBNodes;

    public Tria2JenaUtil(Map<BNode, Node> tria2JenaBNodes) {
        this.tria2JenaBNodes = tria2JenaBNodes;
    }

    public Node convert2JenaNode(NonLiteral nonLiteral, boolean createBlankNode) {
        if (nonLiteral instanceof UriRef) {
            return this.convert2JenaNode((UriRef)nonLiteral);
        }
        return this.convert2JenaNode((BNode)nonLiteral, createBlankNode);
    }

    public Node convert2JenaNode(Literal literal) {
        if (literal == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        if (literal instanceof PlainLiteral) {
            return this.convert2JenaNode((PlainLiteral)literal);
        }
        return this.convert2JenaNode((TypedLiteral)literal);
    }

    public Node convert2JenaNode(PlainLiteral literal) {
        return Node.createLiteral(literal.getLexicalForm(), literal.getLanguage() == null ? null : literal.getLanguage().toString(), false);
    }

    public Node convert2JenaNode(TypedLiteral literal) {
        return Node.createLiteral(literal.getLexicalForm(), null, TypeMapper.getInstance().getSafeTypeByName(literal.getDataType().getUnicodeString()));
    }

    public Node convert2JenaNode(Resource resource) {
        return this.convert2JenaNode(resource, false);
    }

    public Node convert2JenaNode(Resource resource, boolean createBlankNode) {
        if (resource instanceof NonLiteral) {
            return this.convert2JenaNode((NonLiteral)resource, createBlankNode);
        }
        return this.convert2JenaNode((Literal)resource);
    }

    public Node convert2JenaNode(UriRef uriRef) {
        if (uriRef == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        return Node.createURI(uriRef.getUnicodeString());
    }

    public Node convert2JenaNode(BNode bnode) {
        return this.convert2JenaNode(bnode, false);
    }

    public Node convert2JenaNode(BNode bnode, boolean createBlankNode) {
        if (bnode == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        if (bnode instanceof JenaBNodeWrapper) {
            return ((JenaBNodeWrapper)bnode).node;
        }
        Node result = this.tria2JenaBNodes.get(bnode);
        if (result == null && createBlankNode) {
            result = Node.createAnon();
            this.tria2JenaBNodes.put(bnode, result);
        }
        return result;
    }

    public Triple convertTriple(org.apache.clerezza.rdf.core.Triple triple) {
        return this.convertTriple(triple, false);
    }

    public Triple convertTriple(org.apache.clerezza.rdf.core.Triple triple, boolean createBlankNodes) {
        Node subject = this.convert2JenaNode(triple.getSubject(), createBlankNodes);
        Node predicate = this.convert2JenaNode(triple.getPredicate());
        Node object = this.convert2JenaNode(triple.getObject(), createBlankNodes);
        if (subject == null || object == null) {
            return null;
        }
        return new Triple(subject, predicate, object);
    }
}

