/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.facade;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.mem.TrackingTripleIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.jena.commons.Jena2TriaUtil;
import org.apache.clerezza.rdf.jena.commons.Tria2JenaUtil;
import org.wymiwyg.commons.util.collections.BidiMap;
import org.wymiwyg.commons.util.collections.BidiMapImpl;

public class JenaGraph
extends GraphBase
implements Graph {
    final TripleCollection graph;
    final BidiMap<BNode, Node> tria2JenaBNodes = new BidiMapImpl<BNode, Node>();
    final Jena2TriaUtil jena2TriaUtil = new Jena2TriaUtil(this.tria2JenaBNodes.inverse());
    final Tria2JenaUtil tria2JenaUtil = new Tria2JenaUtil(this.tria2JenaBNodes);

    public JenaGraph(TripleCollection graph) {
        this.graph = graph;
    }

    @Override
    public void performAdd(Triple triple) {
        this.graph.add(this.jena2TriaUtil.convertTriple(triple));
    }

    @Override
    public void performDelete(Triple triple) {
        org.apache.clerezza.rdf.core.Triple clerezzaTriple = this.jena2TriaUtil.convertTriple(triple);
        if (clerezzaTriple != null) {
            this.graph.remove(clerezzaTriple);
        }
    }

    private Iterator<Triple> convert(final Iterator<org.apache.clerezza.rdf.core.Triple> base) {
        return new Iterator<Triple>(){
            org.apache.clerezza.rdf.core.Triple lastReturned = null;

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public Triple next() {
                org.apache.clerezza.rdf.core.Triple baseNext;
                this.lastReturned = baseNext = (org.apache.clerezza.rdf.core.Triple)base.next();
                return baseNext == null ? null : JenaGraph.this.tria2JenaUtil.convertTriple(baseNext, true);
            }

            @Override
            public void remove() {
                JenaGraph.this.graph.remove(this.lastReturned);
            }
        };
    }

    private Iterator<org.apache.clerezza.rdf.core.Triple> filter(TripleMatch m) {
        NonLiteral subject = null;
        UriRef predicate = null;
        Resource object = null;
        if (m.getMatchSubject() != null) {
            if (m.getMatchSubject().isLiteral()) {
                return Collections.EMPTY_SET.iterator();
            }
            subject = this.jena2TriaUtil.convertNonLiteral(m.getMatchSubject());
            if (subject == null) {
                return Collections.EMPTY_SET.iterator();
            }
        }
        if (m.getMatchObject() != null && (object = this.jena2TriaUtil.convertJenaNode2Resource(m.getMatchObject())) == null) {
            return Collections.EMPTY_SET.iterator();
        }
        if (m.getMatchPredicate() != null) {
            if (!m.getMatchPredicate().isURI()) {
                return Collections.EMPTY_SET.iterator();
            }
            predicate = this.jena2TriaUtil.convertJenaUri2UriRef(m.getMatchPredicate());
        }
        try {
            return this.graph.filter(subject, predicate, object);
        }
        catch (IllegalArgumentException e) {
            return new HashSet().iterator();
        }
    }

    protected ExtendedIterator graphBaseFind(TripleMatch m) {
        return new TrackingTripleIterator(this.convert(this.filter(m)));
    }
}

