/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.parser;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.InputStream;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.serializedform.ParsingProvider;
import org.apache.clerezza.rdf.core.serializedform.SupportedFormat;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedParsingFormatException;
import org.apache.clerezza.rdf.jena.facade.JenaGraph;

@SupportedFormat(value={"application/rdf+xml", "text/turtle", "application/x-turtle", "text/rdf+nt", "text/rdf+n3"})
public class JenaParserProvider
implements ParsingProvider {
    @Override
    public void parse(MGraph target, InputStream serializedGraph, String formatIdentifier, UriRef baseUri) {
        String jenaFormat = this.getJenaFormat(formatIdentifier);
        JenaGraph graph = new JenaGraph(target);
        Model model = ModelFactory.createModelForGraph(graph);
        String base = baseUri == null ? "http://relative-uri.fake/" : baseUri.getUnicodeString();
        model.read(serializedGraph, base, jenaFormat);
    }

    private String getJenaFormat(String formatIdentifier) {
        int semicolonPos = formatIdentifier.indexOf(59);
        if (semicolonPos > -1) {
            formatIdentifier = formatIdentifier.substring(0, semicolonPos);
        }
        if (formatIdentifier.equals("application/rdf+xml")) {
            return "RDF/XML-ABBREV";
        }
        if (formatIdentifier.equals("text/turtle") || formatIdentifier.equals("application/x-turtle")) {
            return "TURTLE";
        }
        if (formatIdentifier.equals("text/rdf+n3")) {
            return "N3";
        }
        if (formatIdentifier.equals("text/rdf+nt")) {
            return "N-TRIPLE";
        }
        throw new UnsupportedParsingFormatException(formatIdentifier);
    }
}

