/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.fcrepo.camel.FcrepoLink;
import org.fcrepo.camel.FcrepoOperationFailedException;
import org.fcrepo.camel.FcrepoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoClient {
    private static final String DESCRIBED_BY = "describedby";
    private static final String CONTENT_TYPE = "Content-Type";
    private CloseableHttpClient httpclient;
    private Boolean throwExceptionOnFailure = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoClient.class);

    public FcrepoClient(String username, String password, String host, Boolean throwExceptionOnFailure) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        AuthScope scope = null;
        this.throwExceptionOnFailure = throwExceptionOnFailure;
        if (StringUtils.isBlank(username) || StringUtils.isBlank(password)) {
            this.httpclient = HttpClients.createDefault();
        } else {
            LOGGER.debug("Accessing fcrepo with user credentials");
            scope = StringUtils.isBlank(host) ? new AuthScope(AuthScope.ANY) : new AuthScope(new HttpHost(host));
            credsProvider.setCredentials(scope, (Credentials)new UsernamePasswordCredentials(username, password));
            this.httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        }
    }

    public FcrepoResponse head(URI url) throws FcrepoOperationFailedException {
        HttpHead request = new HttpHead(url);
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        int status = response.getStatusLine().getStatusCode();
        String contentType = FcrepoClient.getContentTypeHeader(response);
        LOGGER.debug("Fcrepo HEAD request returned status [{}]", (Object)status);
        if (status >= 200 && status < 400 || !this.throwExceptionOnFailure.booleanValue()) {
            URI describedBy = null;
            List<URI> links = FcrepoClient.getLinkHeaders(response, DESCRIBED_BY);
            if (links.size() == 1) {
                describedBy = links.get(0);
            }
            return new FcrepoResponse(url, status, contentType, describedBy, null);
        }
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    public FcrepoResponse put(URI url, InputStream body, String contentType) throws FcrepoOperationFailedException {
        HttpPut request = new HttpPut(url);
        if (contentType != null) {
            request.addHeader(CONTENT_TYPE, contentType);
        }
        if (body != null) {
            request.setEntity((HttpEntity)new InputStreamEntity(body));
        }
        LOGGER.debug("Fcrepo request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo PUT request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse patch(URI url, InputStream body) throws FcrepoOperationFailedException {
        HttpPatch request = new HttpPatch(url);
        request.addHeader(CONTENT_TYPE, "application/sparql-update");
        request.setEntity((HttpEntity)new InputStreamEntity(body));
        LOGGER.debug("Fcrepo request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo PATCH request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse post(URI url, InputStream body, String contentType) throws FcrepoOperationFailedException {
        HttpPost request = new HttpPost(url);
        if (contentType != null) {
            request.addHeader(CONTENT_TYPE, contentType);
        }
        if (body != null) {
            request.setEntity((HttpEntity)new InputStreamEntity(body));
        }
        LOGGER.debug("Fcrepo request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo POST request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse delete(URI url) throws FcrepoOperationFailedException {
        HttpDelete request = new HttpDelete(url);
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo DELETE request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse get(URI url, String accept, String prefer) throws FcrepoOperationFailedException {
        HttpGet request = new HttpGet(url);
        if (accept != null) {
            request.setHeader("Accept", accept);
        }
        if (prefer != null) {
            request.setHeader("Prefer", prefer);
        }
        LOGGER.debug("Fcrepo request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        int status = response.getStatusLine().getStatusCode();
        String contentType = FcrepoClient.getContentTypeHeader(response);
        LOGGER.debug("Fcrepo GET request returned status [{}]", (Object)status);
        if (status >= 200 && status < 400 || !this.throwExceptionOnFailure.booleanValue()) {
            URI describedBy = null;
            List<URI> links = FcrepoClient.getLinkHeaders(response, DESCRIBED_BY);
            if (links.size() == 1) {
                describedBy = links.get(0);
            }
            return new FcrepoResponse(url, status, contentType, describedBy, FcrepoClient.getEntityContent(response));
        }
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    private HttpResponse executeRequest(HttpRequestBase request) throws FcrepoOperationFailedException {
        try {
            return this.httpclient.execute((HttpUriRequest)request);
        }
        catch (IOException ex) {
            LOGGER.debug("HTTP Operation failed: ", (Throwable)ex);
            throw new FcrepoOperationFailedException(request.getURI(), -1, ex.getMessage());
        }
    }

    private FcrepoResponse fcrepoGenericResponse(URI url, HttpResponse response, Boolean throwExceptionOnFailure) throws FcrepoOperationFailedException {
        int status = response.getStatusLine().getStatusCode();
        String contentTypeHeader = FcrepoClient.getContentTypeHeader(response);
        if (status >= 200 && status < 400 || !throwExceptionOnFailure.booleanValue()) {
            return new FcrepoResponse(url, status, contentTypeHeader, null, FcrepoClient.getEntityContent(response));
        }
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    private static InputStream getEntityContent(HttpResponse response) {
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            return entity.getContent();
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to extract HttpEntity response into an InputStream: ", (Throwable)ex);
            return null;
        }
    }

    private static String getContentTypeHeader(HttpResponse response) {
        Header[] contentTypes = response.getHeaders(CONTENT_TYPE);
        if (contentTypes.length > 0) {
            return contentTypes[0].getValue();
        }
        return null;
    }

    private static List<URI> getLinkHeaders(HttpResponse response, String relationship) {
        Header[] links;
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Header header : links = response.getHeaders("Link")) {
            FcrepoLink link = new FcrepoLink(header.getValue());
            if (!link.getRel().equals(relationship)) continue;
            uris.add(link.getUri());
        }
        return uris;
    }
}

