/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.fcrepo.camel.FcrepoConfiguration;
import org.fcrepo.camel.FcrepoEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoComponent
extends UriEndpointComponent {
    private FcrepoConfiguration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoComponent.class);

    public FcrepoComponent() {
        super(FcrepoEndpoint.class);
    }

    public FcrepoComponent(CamelContext context) {
        super(context, FcrepoEndpoint.class);
    }

    public FcrepoComponent(FcrepoConfiguration config) {
        super(FcrepoEndpoint.class);
        this.configuration = config;
    }

    public FcrepoConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new FcrepoConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(FcrepoConfiguration config) {
        this.configuration = config;
    }

    public void setAuthUsername(String username) {
        this.getConfiguration().setAuthUsername(username);
    }

    public void setAuthPassword(String password) {
        this.getConfiguration().setAuthPassword(password);
    }

    public void setAuthHost(String host) {
        this.getConfiguration().setAuthHost(host);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
        FcrepoConfiguration newConfig = this.configuration == null ? new FcrepoConfiguration() : this.configuration.clone();
        FcrepoEndpoint endpoint = new FcrepoEndpoint(uri, remaining, this, newConfig);
        endpoint.configureProperties(parameters);
        LOGGER.debug("Created Fcrepo Endpoint [{}]", (Object)endpoint);
        return endpoint;
    }
}

