/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.net.URI;

class FcrepoLink {
    private static final String LINK_DELIM = ";";
    private static final String META_REL = "rel";
    private URI uri;
    private String rel;

    public FcrepoLink(String link) {
        this.parse(link);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getRel() {
        return this.rel;
    }

    private void parse(String link) {
        String[] segments;
        if (link != null && (segments = link.split(LINK_DELIM)).length == 2) {
            this.uri = FcrepoLink.getLinkPart(segments[0]);
            if (this.uri != null) {
                this.rel = FcrepoLink.getRelPart(segments[1]);
            }
        }
    }

    private static String getRelPart(String relPart) {
        String[] segments = relPart.trim().split("=");
        if (segments.length != 2 || !META_REL.equals(segments[0])) {
            return null;
        }
        String relValue = segments[1];
        if (relValue.startsWith("\"") && relValue.endsWith("\"")) {
            return relValue.substring(1, relValue.length() - 1);
        }
        return relValue;
    }

    private static URI getLinkPart(String uriPart) {
        String linkPart = uriPart.trim();
        if (!linkPart.startsWith("<") || !linkPart.endsWith(">")) {
            return null;
        }
        return URI.create(linkPart.substring(1, linkPart.length() - 1));
    }
}

