/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.camel.FcrepoClient;
import org.fcrepo.camel.FcrepoEndpoint;
import org.fcrepo.camel.FcrepoOperationFailedException;
import org.fcrepo.camel.FcrepoResponse;
import org.fcrepo.camel.HttpMethods;
import org.fcrepo.camel.RdfNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoProducer
extends DefaultProducer {
    public static final String DEFAULT_CONTENT_TYPE = "application/rdf+xml";
    public static final int DEFAULT_HTTPS_PORT = 443;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoProducer.class);
    private FcrepoEndpoint endpoint;
    private FcrepoClient client;

    public FcrepoProducer(FcrepoEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.client = new FcrepoClient(endpoint.getAuthUsername(), endpoint.getAuthPassword(), endpoint.getAuthHost(), endpoint.getThrowExceptionOnFailure());
    }

    public void process(Exchange exchange) throws FcrepoOperationFailedException {
        FcrepoResponse response;
        Message in = exchange.getIn();
        HttpMethods method = this.getMethod(exchange);
        String contentType = this.getContentType(exchange);
        String accept = this.getAccept(exchange);
        String url = this.getUrl(exchange);
        String prefer = this.getPrefer(exchange);
        LOGGER.debug("Fcrepo Request [{}] with method [{}]", (Object)url, (Object)method);
        switch (method) {
            case PATCH: {
                response = this.client.patch(this.getMetadataUri(url), (InputStream)in.getBody(InputStream.class));
                exchange.getIn().setBody((Object)FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case PUT: {
                response = this.client.put(URI.create(url), (InputStream)in.getBody(InputStream.class), contentType);
                exchange.getIn().setBody((Object)FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case POST: {
                response = this.client.post(URI.create(url), (InputStream)in.getBody(InputStream.class), contentType);
                exchange.getIn().setBody((Object)FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case DELETE: {
                response = this.client.delete(URI.create(url));
                exchange.getIn().setBody((Object)FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
                break;
            }
            case HEAD: {
                response = this.client.head(URI.create(url));
                exchange.getIn().setBody(null);
                break;
            }
            default: {
                response = this.client.get(this.endpoint.getMetadata() != false ? this.getMetadataUri(url) : URI.create(url), accept, prefer);
                exchange.getIn().setBody((Object)FcrepoProducer.extractResponseBodyAsStream(response.getBody(), exchange));
            }
        }
        exchange.getIn().setHeader("Content-Type", (Object)response.getContentType());
        exchange.getIn().setHeader("CamelHttpResponseCode", (Object)response.getStatusCode());
    }

    private URI getMetadataUri(String url) throws FcrepoOperationFailedException {
        FcrepoResponse headResponse = this.client.head(URI.create(url));
        if (headResponse.getLocation() != null) {
            return headResponse.getLocation();
        }
        return URI.create(url);
    }

    private HttpMethods getMethod(Exchange exchange) {
        HttpMethods method = (HttpMethods)((Object)exchange.getIn().getHeader("CamelHttpMethod", HttpMethods.class));
        if (method == null) {
            return HttpMethods.GET;
        }
        return method;
    }

    private String getContentType(Exchange exchange) {
        String contentTypeString = ExchangeHelper.getContentType((Exchange)exchange);
        if (!StringUtils.isBlank(this.endpoint.getContentType())) {
            return this.endpoint.getContentType();
        }
        if (!StringUtils.isBlank(contentTypeString)) {
            return contentTypeString;
        }
        return null;
    }

    private String getAccept(Exchange exchange) {
        Message in = exchange.getIn();
        String fcrepoTransform = (String)in.getHeader("CamelFcrepoTransform", String.class);
        String acceptHeader = this.getAcceptHeader(exchange);
        if (!StringUtils.isBlank(this.endpoint.getTransform()) || !StringUtils.isBlank(fcrepoTransform)) {
            return "application/json";
        }
        if (!StringUtils.isBlank(this.endpoint.getAccept())) {
            return this.endpoint.getAccept();
        }
        if (!StringUtils.isBlank(acceptHeader)) {
            return acceptHeader;
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private String getAcceptHeader(Exchange exchange) {
        Message in = exchange.getIn();
        if (!StringUtils.isBlank((CharSequence)in.getHeader("CamelAcceptContentType", String.class))) {
            return (String)in.getHeader("CamelAcceptContentType", String.class);
        }
        if (!StringUtils.isBlank((CharSequence)in.getHeader("Accept", String.class))) {
            return (String)in.getHeader("Accept", String.class);
        }
        return null;
    }

    private String getBaseUrlWithScheme() {
        String baseUrl = this.endpoint.getBaseUrl();
        StringBuilder url = new StringBuilder();
        if (!baseUrl.startsWith("http:") && !baseUrl.startsWith("https:")) {
            if (URI.create("http://" + baseUrl).getPort() == 443) {
                url.append("https://");
            } else {
                url.append("http://");
            }
        }
        url.append(baseUrl);
        return url.toString();
    }

    private String getPathFromHeaders(Exchange exchange) {
        Message in = exchange.getIn();
        if (!StringUtils.isBlank((CharSequence)in.getHeader("CamelFcrepoIdentifier", String.class))) {
            return (String)in.getHeader("CamelFcrepoIdentifier", String.class);
        }
        if (!StringUtils.isBlank((CharSequence)in.getHeader("org.fcrepo.jms.identifier", String.class))) {
            return (String)in.getHeader("org.fcrepo.jms.identifier", String.class);
        }
        return "";
    }

    private String getTransformPath(Exchange exchange) {
        Message in = exchange.getIn();
        HttpMethods method = this.getMethod(exchange);
        String transformProgram = (String)in.getHeader("CamelFcrepoTransform", String.class);
        String fcrTransform = "/fcr:transform";
        if (!StringUtils.isBlank(this.endpoint.getTransform()) || !StringUtils.isBlank(transformProgram)) {
            if (method == HttpMethods.POST) {
                return "/fcr:transform";
            }
            if (method == HttpMethods.GET) {
                if (!StringUtils.isBlank(transformProgram)) {
                    return "/fcr:transform/" + transformProgram;
                }
                return "/fcr:transform/" + this.endpoint.getTransform();
            }
        }
        return "";
    }

    private String getUrl(Exchange exchange) {
        StringBuilder url = new StringBuilder();
        String transformPath = this.getTransformPath(exchange);
        HttpMethods method = this.getMethod(exchange);
        url.append(this.getBaseUrlWithScheme());
        url.append(this.getPathFromHeaders(exchange));
        if (!StringUtils.isBlank(transformPath)) {
            url.append(transformPath);
        } else if (method == HttpMethods.DELETE && this.endpoint.getTombstone().booleanValue()) {
            url.append("/fcr:tombstone");
        }
        return url.toString();
    }

    private String getPrefer(Exchange exchange) {
        Message in = exchange.getIn();
        if (this.getMethod(exchange) == HttpMethods.GET) {
            if (!StringUtils.isBlank((CharSequence)in.getHeader("CamelFcrepoPrefer", String.class))) {
                return (String)in.getHeader("CamelFcrepoPrefer", String.class);
            }
            return this.buildPreferHeader(this.endpoint.getPreferInclude(), this.endpoint.getPreferOmit());
        }
        return null;
    }

    private String buildPreferHeader(String include, String omit) {
        if (StringUtils.isBlank(include) && StringUtils.isBlank(omit)) {
            return null;
        }
        StringBuilder prefer = new StringBuilder("return=representation;");
        if (!StringUtils.isBlank(include)) {
            prefer.append(" include=\"" + this.addPreferNamespace(include) + "\";");
        }
        if (!StringUtils.isBlank(omit)) {
            prefer.append(" omit=\"" + this.addPreferNamespace(omit) + "\";");
        }
        return prefer.toString();
    }

    private String addPreferNamespace(String property) {
        String prefer = RdfNamespaces.PREFER_PROPERTIES.get(property);
        if (!StringUtils.isBlank(prefer)) {
            return prefer;
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static InputStream extractResponseBodyAsStream(InputStream is, Exchange exchange) {
        if (is == null) {
            return null;
        }
        try {
            InputStream inputStream;
            Throwable throwable;
            CachedOutputStream cos;
            block18: {
                block19: {
                    cos = new CachedOutputStream(exchange, false);
                    throwable = null;
                    IOHelper.copy((InputStream)is, (OutputStream)cos);
                    inputStream = cos.getWrappedInputStream();
                    if (cos == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        cos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                cos.close();
            }
            return inputStream;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (cos != null) {
                            if (throwable != null) {
                                try {
                                    cos.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                cos.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException ex) {
                    LOGGER.debug("Error extracting body from http request", (Throwable)ex);
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            IOHelper.close((Closeable)is, (String)"Extracting response body", (Logger)LOGGER);
        }
    }
}

