/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.fcrepo.camel.FcrepoHttpClientBuilder;
import org.fcrepo.camel.FcrepoLink;
import org.fcrepo.camel.FcrepoOperationFailedException;
import org.fcrepo.camel.FcrepoResponse;
import org.fcrepo.camel.HttpMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoClient {
    private static final String DESCRIBED_BY = "describedby";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String LOCATION = "Location";
    private CloseableHttpClient httpclient;
    private Boolean throwExceptionOnFailure = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoClient.class);

    public FcrepoClient(String username, String password, String host, Boolean throwExceptionOnFailure) {
        FcrepoHttpClientBuilder client = new FcrepoHttpClientBuilder(username, password, host);
        this.throwExceptionOnFailure = throwExceptionOnFailure;
        this.httpclient = client.build();
    }

    public FcrepoResponse head(URI url) throws FcrepoOperationFailedException {
        HttpRequestBase request = HttpMethods.HEAD.createRequest(url);
        HttpResponse response = this.executeRequest(request);
        int status = response.getStatusLine().getStatusCode();
        String contentType = FcrepoClient.getContentTypeHeader(response);
        LOGGER.debug("Fcrepo HEAD request returned status [{}]", (Object)status);
        if (status >= 200 && status < 400 || !this.throwExceptionOnFailure.booleanValue()) {
            URI describedBy = null;
            List<URI> links = FcrepoClient.getLinkHeaders(response, DESCRIBED_BY);
            if (links.size() == 1) {
                describedBy = links.get(0);
            }
            return new FcrepoResponse(url, status, contentType, describedBy, null);
        }
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    public FcrepoResponse put(URI url, InputStream body, String contentType) throws FcrepoOperationFailedException {
        HttpMethods method = HttpMethods.PUT;
        HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)method.createRequest(url);
        if (contentType != null) {
            request.addHeader(CONTENT_TYPE, contentType);
        }
        if (body != null) {
            request.setEntity((HttpEntity)new InputStreamEntity(body));
        }
        LOGGER.debug("Fcrepo PUT request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo PUT request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse patch(URI url, InputStream body) throws FcrepoOperationFailedException {
        HttpMethods method = HttpMethods.PATCH;
        HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)method.createRequest(url);
        request.addHeader(CONTENT_TYPE, "application/sparql-update");
        request.setEntity((HttpEntity)new InputStreamEntity(body));
        LOGGER.debug("Fcrepo PATCH request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo PATCH request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse post(URI url, InputStream body, String contentType) throws FcrepoOperationFailedException {
        HttpMethods method = HttpMethods.POST;
        HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)method.createRequest(url);
        if (contentType != null) {
            request.addHeader(CONTENT_TYPE, contentType);
        }
        if (body != null) {
            request.setEntity((HttpEntity)new InputStreamEntity(body));
        }
        LOGGER.debug("Fcrepo POST request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest((HttpRequestBase)request);
        LOGGER.debug("Fcrepo POST request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse delete(URI url) throws FcrepoOperationFailedException {
        HttpRequestBase request = HttpMethods.DELETE.createRequest(url);
        HttpResponse response = this.executeRequest(request);
        LOGGER.debug("Fcrepo DELETE request returned status [{}]", (Object)response.getStatusLine().getStatusCode());
        return this.fcrepoGenericResponse(url, response, this.throwExceptionOnFailure);
    }

    public FcrepoResponse get(URI url, String accept, String prefer) throws FcrepoOperationFailedException {
        HttpRequestBase request = HttpMethods.GET.createRequest(url);
        if (accept != null) {
            request.setHeader("Accept", accept);
        }
        if (prefer != null) {
            request.setHeader("Prefer", prefer);
        }
        LOGGER.debug("Fcrepo GET request headers: {}", (Object[])request.getAllHeaders());
        HttpResponse response = this.executeRequest(request);
        int status = response.getStatusLine().getStatusCode();
        String contentType = FcrepoClient.getContentTypeHeader(response);
        LOGGER.debug("Fcrepo GET request returned status [{}]", (Object)status);
        if (status >= 200 && status < 400 || !this.throwExceptionOnFailure.booleanValue()) {
            URI describedBy = null;
            List<URI> links = FcrepoClient.getLinkHeaders(response, DESCRIBED_BY);
            if (links.size() == 1) {
                describedBy = links.get(0);
            }
            return new FcrepoResponse(url, status, contentType, describedBy, FcrepoClient.getEntityContent(response));
        }
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    private HttpResponse executeRequest(HttpRequestBase request) throws FcrepoOperationFailedException {
        try {
            return this.httpclient.execute((HttpUriRequest)request);
        }
        catch (IOException ex) {
            LOGGER.debug("HTTP Operation failed: ", (Throwable)ex);
            throw new FcrepoOperationFailedException(request.getURI(), -1, ex.getMessage());
        }
    }

    private FcrepoResponse fcrepoGenericResponse(URI url, HttpResponse response, Boolean throwExceptionOnFailure) throws FcrepoOperationFailedException {
        int status = response.getStatusLine().getStatusCode();
        URI locationHeader = FcrepoClient.getLocationHeader(response);
        String contentTypeHeader = FcrepoClient.getContentTypeHeader(response);
        if (status >= 200 && status < 400 || !throwExceptionOnFailure.booleanValue()) {
            return new FcrepoResponse(url, status, contentTypeHeader, locationHeader, FcrepoClient.getEntityContent(response));
        }
        throw new FcrepoOperationFailedException(url, status, response.getStatusLine().getReasonPhrase());
    }

    private static InputStream getEntityContent(HttpResponse response) {
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            return entity.getContent();
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to extract HttpEntity response into an InputStream: ", (Throwable)ex);
            return null;
        }
    }

    private static URI getLocationHeader(HttpResponse response) {
        Header location = response.getFirstHeader(LOCATION);
        if (location != null) {
            return URI.create(location.getValue());
        }
        return null;
    }

    private static String getContentTypeHeader(HttpResponse response) {
        Header contentType = response.getFirstHeader(CONTENT_TYPE);
        if (contentType != null) {
            return contentType.getValue();
        }
        return null;
    }

    private static List<URI> getLinkHeaders(HttpResponse response, String relationship) {
        Header[] links;
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Header header : links = response.getHeaders("Link")) {
            FcrepoLink link = new FcrepoLink(header.getValue());
            if (!link.getRel().equals(relationship)) continue;
            uris.add(link.getUri());
        }
        return uris;
    }
}

