/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.io.IOException;
import org.apache.camel.Message;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.commons.lang3.StringUtils;

public final class ProcessorUtils {
    private ProcessorUtils() {
    }

    private static String trimTrailingSlash(String path) {
        String trimmed = path;
        while (trimmed.endsWith("/")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    public static String getSubjectUri(Message in) throws IOException {
        StringBuilder base = new StringBuilder("");
        if (in.getHeader("CamelFcrepoBaseUrl") != null) {
            base.append(ProcessorUtils.trimTrailingSlash((String)in.getHeader("CamelFcrepoBaseUrl", String.class)));
        } else if (in.getHeader("org.fcrepo.jms.baseURL") != null) {
            base.append(ProcessorUtils.trimTrailingSlash((String)in.getHeader("org.fcrepo.jms.baseURL", String.class)));
        } else {
            throw new IOException("No baseURL header available!");
        }
        if (in.getHeader("CamelFcrepoIdentifier") != null) {
            base.append((String)in.getHeader("CamelFcrepoIdentifier", String.class));
        } else if (in.getHeader("org.fcrepo.jms.identifier") != null) {
            base.append((String)in.getHeader("org.fcrepo.jms.identifier", String.class));
        }
        return base.toString();
    }

    public static String deleteWhere(String subject, String namedGraph) {
        StringBuilder stmt = new StringBuilder("DELETE WHERE { ");
        if (!StringUtils.isBlank((CharSequence)namedGraph)) {
            stmt.append("GRAPH ");
            stmt.append(new UriRef(namedGraph));
            stmt.append(" { ");
        }
        stmt.append(new UriRef(subject));
        stmt.append(" ?p ?o ");
        if (!StringUtils.isBlank((CharSequence)namedGraph)) {
            stmt.append("} ");
        }
        stmt.append("}");
        return stmt.toString();
    }

    public static String insertData(String serializedGraph, String namedGraph) {
        StringBuilder query = new StringBuilder("INSERT DATA { ");
        if (!StringUtils.isBlank((CharSequence)namedGraph)) {
            query.append("GRAPH ");
            query.append(new UriRef(namedGraph));
            query.append(" { ");
        }
        query.append(serializedGraph);
        if (!StringUtils.isBlank((CharSequence)namedGraph)) {
            query.append("} ");
        }
        query.append("}");
        return query.toString();
    }
}

