/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.jena.parser.JenaParserProvider;
import org.apache.clerezza.rdf.jena.serializer.JenaSerializerProvider;
import org.fcrepo.camel.processor.ProcessorUtils;

public class SparqlInsertProcessor
implements Processor {
    public void process(Exchange exchange) throws IOException {
        Message in = exchange.getIn();
        JenaParserProvider parser = new JenaParserProvider();
        JenaSerializerProvider serializer = new JenaSerializerProvider();
        SimpleMGraph graph = new SimpleMGraph();
        String contentType = (String)in.getHeader("Content-Type", String.class);
        String namedGraph = (String)in.getHeader("CamelFcrepoNamedGraph", String.class);
        ByteArrayOutputStream serializedGraph = new ByteArrayOutputStream();
        String subject = ProcessorUtils.getSubjectUri(in);
        parser.parse((MGraph)graph, (InputStream)in.getBody(InputStream.class), "application/n-triples".equals(contentType) ? "text/rdf+nt" : contentType, new UriRef(subject));
        serializer.serialize((OutputStream)serializedGraph, (TripleCollection)graph.getGraph(), "text/rdf+nt");
        StringBuilder query = new StringBuilder("update=");
        query.append(ProcessorUtils.insertData(serializedGraph.toString("UTF-8"), namedGraph));
        exchange.getIn().setBody((Object)query.toString());
        exchange.getIn().setHeader("CamelHttpMethod", (Object)"POST");
        exchange.getIn().setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
    }
}

